/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.foshu.AlgoFOSHU;
import java.io.IOException;

public class DescriptionAlgoFOSHU
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "FOSHU";
    }

    @Override
    public String getAlgorithmCategory() {
        return "HIGH-UTILITY PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/FOSHU.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        double min_utility_ratio = DescriptionAlgoFOSHU.getParamAsDouble(parameters[0]);
        AlgoFOSHU algo = new AlgoFOSHU();
        algo.runAlgorithm(inputFile, outputFile, min_utility_ratio);
        algo.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minimum utility ratio", "(e.g. 0.8)", Double.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Transaction database with shelf-time periods and positive/negative utility values"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "High-utility patterns", "On-shelf high-utility itemsets"};
    }
}

