/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.associationrules.agrawal94_association_rules.AlgoAgrawalFaster94;
import ca.pfv.spmf.algorithms.frequentpatterns.fpgrowth.AlgoFPGrowth;
import ca.pfv.spmf.patterns.itemset_array_integers_with_count.Itemsets;
import java.io.IOException;

public class DescriptionAlgoFPGrowthAssociationRules
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "FPGrowth_association_rules";
    }

    @Override
    public String getAlgorithmCategory() {
        return "ASSOCIATION RULE MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/AssociationRules.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        double minsup = DescriptionAlgoFPGrowthAssociationRules.getParamAsDouble(parameters[0]);
        double minconf = DescriptionAlgoFPGrowthAssociationRules.getParamAsDouble(parameters[1]);
        int maxAntecedentLength = 400;
        int maxConsequentLength = 400;
        if (parameters.length >= 3 && !"".equals(parameters[2])) {
            maxAntecedentLength = DescriptionAlgoFPGrowthAssociationRules.getParamAsInteger(parameters[2]);
        }
        if (parameters.length >= 4 && !"".equals(parameters[3])) {
            maxConsequentLength = DescriptionAlgoFPGrowthAssociationRules.getParamAsInteger(parameters[3]);
        }
        AlgoFPGrowth fpgrowth = new AlgoFPGrowth();
        fpgrowth.setMaximumPatternLength(maxAntecedentLength + maxConsequentLength);
        Itemsets patterns = fpgrowth.runAlgorithm(inputFile, null, minsup);
        fpgrowth.printStats();
        int databaseSize = fpgrowth.getDatabaseSize();
        AlgoAgrawalFaster94 algoAgrawal = new AlgoAgrawalFaster94();
        algoAgrawal.setMaxAntecedentLength(maxAntecedentLength);
        algoAgrawal.setMaxConsequentLength(maxConsequentLength);
        algoAgrawal.runAlgorithm(patterns, outputFile, databaseSize, minconf);
        algoAgrawal.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup (%)", "(e.g. 0.5 or 50%)", Double.class, false), new DescriptionOfParameter("Minconf (%)", "(e.g. 0.6 or 60%)", Double.class, false), new DescriptionOfParameter("Max antecedent length", "(e.g. 2 items)", Integer.class, true), new DescriptionOfParameter("Max consequent length", "(e.g. 2 items)", Integer.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Simple transaction database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Association rules"};
    }
}

