/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.sequentialpatterns.clofast.AlgoFast;
import java.io.IOException;

public class DescriptionAlgoFast
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "Fast";
    }

    @Override
    public String getAlgorithmCategory() {
        return "SEQUENTIAL PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/FAST.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        AlgoFast algo = new AlgoFast();
        if (parameters.length >= 2 && !"".equals(parameters[1])) {
            algo.setMaximumSupport(DescriptionAlgoFast.getParamAsFloat(parameters[1]));
        }
        algo.runAlgorithm(inputFile, outputFile, DescriptionAlgoFast.getParamAsFloat(parameters[0]));
        algo.printStatistics();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup (%)", "(e.g. 0.5 or 50%)", Float.class, false), new DescriptionOfParameter("Maxsup (%)", "(e.g. 0.8 or 80%)", Float.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Salvemini E, Fumarola F, Malerba D, Han J.";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Sequence database", "Simple sequence database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Sequential patterns", "Frequent sequential patterns"};
    }
}

