/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.AlgoFournierViger08;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.SequenceDatabase;
import java.io.IOException;

public class DescriptionAlgoFournier08ClosedTime
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "Fournier08-Closed+time";
    }

    @Override
    public String getAlgorithmCategory() {
        return "SEQUENTIAL PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/ClosedSequentialPatterns_TimeConstraints.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        double minsup = DescriptionAlgoFournier08ClosedTime.getParamAsDouble(parameters[0]);
        double minInterval = DescriptionAlgoFournier08ClosedTime.getParamAsDouble(parameters[1]);
        double maxInterval = DescriptionAlgoFournier08ClosedTime.getParamAsDouble(parameters[2]);
        double minWholeInterval = DescriptionAlgoFournier08ClosedTime.getParamAsDouble(parameters[3]);
        double maxWholeInterval = DescriptionAlgoFournier08ClosedTime.getParamAsDouble(parameters[4]);
        SequenceDatabase database = new SequenceDatabase();
        database.loadFile(inputFile);
        AlgoFournierViger08 algo = new AlgoFournierViger08(minsup, minInterval, maxInterval, minWholeInterval, maxWholeInterval, null, true, true);
        algo.runAlgorithm(database, outputFile);
        algo.printStatistics();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup (%)", "(e.g. 0.4 or 40%)", Double.class, false), new DescriptionOfParameter("Min time interval", "(e.g. 0 itemsets)", Double.class, false), new DescriptionOfParameter("Max time interval", "(e.g. 2 itemsets)", Double.class, false), new DescriptionOfParameter("Min whole time interval", "(e.g. 0 itemsets)", Double.class, false), new DescriptionOfParameter("Max whole time interval", "(e.g. 2 itemsets)", Double.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Sequence database", "Sequence Database with timestamps"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Sequential patterns", "Frequent Sequential patterns", "Frequent closed sequential patterns with timestamps"};
    }
}

