/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.AlgoCHUIMiner;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.AlgoGHUIMINER;
import ca.pfv.spmf.algorithms.frequentpatterns.hui_miner.Itemset;
import java.io.IOException;
import java.util.List;
import java.util.Set;

public class DescriptionAlgoGHUIMiner
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "GHUI-Miner";
    }

    @Override
    public String getAlgorithmCategory() {
        return "HIGH-UTILITY PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/GHUIMiner.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int minutil = DescriptionAlgoGHUIMiner.getParamAsInteger(parameters[0]);
        System.out.println("Step 1: Mining CHUIs...");
        AlgoCHUIMiner chuiMineClosed = new AlgoCHUIMiner(true);
        List<List<Itemset>> closedItemsets = chuiMineClosed.runAlgorithm(inputFile, minutil, null);
        chuiMineClosed.printStats();
        Set<Integer> itemsInClosedItemsets = chuiMineClosed.setOfItemsInClosedItemsets;
        System.out.println("Step 2: Mining GHUIs...");
        AlgoGHUIMINER ghuiMiner = new AlgoGHUIMINER();
        ghuiMiner.runAlgorithm(inputFile, outputFile, minutil, closedItemsets, itemsInClosedItemsets);
        ghuiMiner.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minimum utility", "(e.g. 30)", Integer.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Transaction database with utility values"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Generator patterns", "High-utility patterns", "Generator itemsets", "High-utility itemsets", "Generators of high-utility itemsets"};
    }
}

