/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.graph_mining.tkg.AlgoGSPAN;
import java.io.IOException;

public class DescriptionAlgoGSPAN
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "GSPAN";
    }

    @Override
    public String getAlgorithmCategory() {
        return "GRAPH PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/GSPAN.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException, ClassNotFoundException {
        double minSupport = DescriptionAlgoGSPAN.getParamAsDouble(parameters[0]);
        int maxNumberOfEdges = Integer.MAX_VALUE;
        if (parameters.length >= 2 && !"".equals(parameters[1])) {
            maxNumberOfEdges = DescriptionAlgoGSPAN.getParamAsInteger(parameters[1]);
        }
        boolean outputSingleFrequentVertices = true;
        if (parameters.length >= 3 && !"".equals(parameters[2])) {
            outputSingleFrequentVertices = DescriptionAlgoGSPAN.getParamAsBoolean(parameters[2]);
        }
        boolean outputDotFile = false;
        if (parameters.length >= 4 && !"".equals(parameters[3])) {
            outputDotFile = DescriptionAlgoGSPAN.getParamAsBoolean(parameters[3]);
        }
        boolean outputGraphIds = true;
        if (parameters.length >= 5 && !"".equals(parameters[4])) {
            outputGraphIds = DescriptionAlgoGSPAN.getParamAsBoolean(parameters[4]);
        }
        AlgoGSPAN algo = new AlgoGSPAN();
        algo.runAlgorithm(inputFile, outputFile, minSupport, outputSingleFrequentVertices, outputDotFile, maxNumberOfEdges, outputGraphIds);
        algo.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup (%)", "(e.g. 0.9 or 90%)", Double.class, false), new DescriptionOfParameter("Max Number of Edges", "(e.g. 2)", Integer.class, true), new DescriptionOfParameter("Output Single Vertices", "(e.g. true)", Boolean.class, true), new DescriptionOfParameter("Output DOT file", "(e.g. false)", Boolean.class, true), new DescriptionOfParameter("Output Graph IDs", "(e.g. true)", Boolean.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Chao Cheng and Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Graph database", "Labeled graph database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Subgraphs", "Frequent subgraphs"};
    }
}

