/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.tools.dataset_generator.TransactionDatasetUtilityGenerator;
import java.io.IOException;

public class DescriptionAlgoGenerateUtilityTransactionDB
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "Generate_utility_values_for_transaction_database";
    }

    @Override
    public String getAlgorithmCategory() {
        return "DATASET TOOLS";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/Calculating_transaction_database_utility_statistics.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int maxQuantity = DescriptionAlgoGenerateUtilityTransactionDB.getParamAsInteger(parameters[0]);
        int maxUnitProfit = DescriptionAlgoGenerateUtilityTransactionDB.getParamAsInteger(parameters[1]);
        TransactionDatasetUtilityGenerator generator = new TransactionDatasetUtilityGenerator();
        generator.convert(inputFile, outputFile, maxQuantity, maxUnitProfit);
        System.out.println("Transaction database with utility values generated.  ");
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Maximum quantity", "(e.g. 10)", Integer.class, false), new DescriptionOfParameter("Multiplicative factor", "(e.g. 4)", Integer.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Simple transaction database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Transaction database with utility values"};
    }
}

