/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.episodes.huespan.AlgoHUESpan;
import java.io.IOException;

public class DescriptionAlgoHUESPAN
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "HUE-SPAN";
    }

    @Override
    public String getAlgorithmCategory() {
        return "EPISODE MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/HUE_SPAN.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        double minutil = DescriptionAlgoHUESPAN.getParamAsDouble(parameters[0]);
        int maxTimeDuration = DescriptionAlgoHUESPAN.getParamAsInteger(parameters[1]);
        boolean outputSingleEvents = DescriptionAlgoHUESPAN.getParamAsBoolean(parameters[2]);
        boolean useTraditionalUtility = false;
        if (parameters.length >= 4 && !"".equals(parameters[3])) {
            useTraditionalUtility = DescriptionAlgoHUESPAN.getParamAsBoolean(parameters[3]);
        }
        AlgoHUESpan algo = new AlgoHUESpan();
        algo.runAlgorithm(inputFile, outputFile, minutil, maxTimeDuration, !useTraditionalUtility, true, outputSingleEvents, true, true);
        algo.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minimum utility", "(e.g. 45%)", Double.class, false), new DescriptionOfParameter("Max. Time duration", "(e.g. 2)", Integer.class, false), new DescriptionOfParameter("Output single events", "(e.g. true)", Boolean.class, false), new DescriptionOfParameter("Use traditional utility?", "(default: false)", Boolean.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Yang Peng et al.";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Transaction database with utility values"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Episodes", "High-utility patterns", "High-Utility episodes"};
    }
}

