/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.huim_abc.AlgoHUIM_ABC;
import java.io.IOException;

public class DescriptionAlgoHUIM_ABC
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "HUIM-ABC";
    }

    @Override
    public String getAlgorithmCategory() {
        return "HIGH-UTILITY PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/HUIM-ABC.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int minutil = DescriptionAlgoHUIM_ABC.getParamAsInteger(parameters[0]);
        AlgoHUIM_ABC algo = new AlgoHUIM_ABC();
        if (parameters.length >= 2 && !"".equals(parameters[1])) {
            algo.setBucketNum(DescriptionAlgoHUIM_ABC.getParamAsInteger(parameters[1]));
        }
        algo.runAlgorithm(inputFile, outputFile, minutil);
        algo.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minimum utility", "(e.g. 40)", Integer.class, false), new DescriptionOfParameter("Bucket number", "(e.g. 2)", Integer.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Wei Song, Chaomin Huang";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Transaction database with utility values"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "High-utility patterns", "High-utility itemsets"};
    }
}

