/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.sequential_rules.husrm.AlgoHUSRM;
import java.io.IOException;

public class DescriptionAlgoHUSRM
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "HUSRM";
    }

    @Override
    public String getAlgorithmCategory() {
        return "HIGH-UTILITY PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/HUSRM.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int minutil = DescriptionAlgoHUSRM.getParamAsInteger(parameters[0]);
        double minconf = DescriptionAlgoHUSRM.getParamAsDouble(parameters[1]);
        int maxAntecedentSize = Integer.MAX_VALUE;
        if (parameters.length >= 3 && !"".equals(parameters[2])) {
            maxAntecedentSize = DescriptionAlgoHUSRM.getParamAsInteger(parameters[2]);
        }
        int maxConsequentSize = Integer.MAX_VALUE;
        if (parameters.length >= 4 && !"".equals(parameters[3])) {
            maxConsequentSize = DescriptionAlgoHUSRM.getParamAsInteger(parameters[3]);
        }
        int maximumSequenceCount = Integer.MAX_VALUE;
        AlgoHUSRM algo = new AlgoHUSRM();
        algo.runAlgorithm(inputFile, outputFile, minconf, minutil, maxAntecedentSize, maxConsequentSize, maximumSequenceCount);
        algo.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minimum utility", "(e.g. 40)", Integer.class, false), new DescriptionOfParameter("Minimum confidence (%)", "(e.g. 0.7 or 70%)", Double.class, false), new DescriptionOfParameter("Min antecedent size", "(e.g. 4)", Integer.class, true), new DescriptionOfParameter("Max consequent size", "(e.g. 4)", Integer.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Souleymane Zida, Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Sequence database", "Sequence Database with utility values"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "High-utility patterns", "Sequential rules", "High-utility rules", "High-utility sequential rules"};
    }
}

