/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.clustering.distanceFunctions.DistanceFunction;
import ca.pfv.spmf.algorithms.clustering.kmeans.AlgoKMeans;
import java.io.IOException;

public class DescriptionAlgoKMeans
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "KMeans";
    }

    @Override
    public String getAlgorithmCategory() {
        return "CLUSTERING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/KMeans.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int k = DescriptionAlgoKMeans.getParamAsInteger(parameters[0]);
        String distanceFunctionName = DescriptionAlgoKMeans.getParamAsString(parameters[1]);
        DistanceFunction distanceFunction = DistanceFunction.getDistanceFunctionByName(distanceFunctionName);
        String separator = parameters.length > 2 && !"".equals(parameters[2]) ? DescriptionAlgoKMeans.getParamAsString(parameters[2]) : " ";
        AlgoKMeans algoKMeans = new AlgoKMeans();
        algoKMeans.runAlgorithm(inputFile, k, distanceFunction, separator);
        algoKMeans.printStatistics();
        algoKMeans.saveToFile(outputFile);
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("k", "(e.g. 3)", Integer.class, false), new DescriptionOfParameter("Distance function", "(e.g. euclidian, cosine...)", String.class, false), new DescriptionOfParameter("separator", "(default: ' ')", String.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Database of double vectors"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Clusters"};
    }
}

