/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.lthui_miner.AlgoLTHUIMiner;
import java.io.IOException;

public class DescriptionAlgoLTHUIMiner
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "LTHUI-Miner";
    }

    @Override
    public String getAlgorithmCategory() {
        return "HIGH-UTILITY PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/LTHUIMiner_algorithm.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int lminutil = DescriptionAlgoLTHUIMiner.getParamAsInteger(parameters[0]);
        int winlen = DescriptionAlgoLTHUIMiner.getParamAsInteger(parameters[1]);
        int binlen = DescriptionAlgoLTHUIMiner.getParamAsInteger(parameters[2]);
        double minslope = DescriptionAlgoLTHUIMiner.getParamAsDouble(parameters[3]);
        long databaseStartTimestamp = -1L;
        if (parameters.length >= 5 && !"".equals(parameters[4])) {
            databaseStartTimestamp = Long.parseLong(DescriptionAlgoLTHUIMiner.getParamAsString(parameters[4]));
        }
        boolean outputIndex = false;
        if (parameters.length >= 5 && !"".equals(parameters[5])) {
            outputIndex = DescriptionAlgoLTHUIMiner.getParamAsBoolean(parameters[5]);
        }
        AlgoLTHUIMiner lthuiminer = new AlgoLTHUIMiner();
        lthuiminer.runAlgorithm(inputFile, outputFile, lminutil, winlen, binlen, minslope, databaseStartTimestamp, outputIndex);
        lthuiminer.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minimum utility", "(e.g. 20)", Integer.class, false), new DescriptionOfParameter("Sliding window length", "(e.g. 9)", Integer.class, false), new DescriptionOfParameter("Bin length", "(e.g. 3)", Integer.class, false), new DescriptionOfParameter("Minimum slope", "(e.g. 5)", Double.class, false), new DescriptionOfParameter("The start timestamp of the database", "", Long.class, true), new DescriptionOfParameter("Whether to output period with the bin index", "", Boolean.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Yanjun Yang, Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Transaction database with utility values and time"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "High-utility patterns", "Locally trending high-utility itemsets"};
    }
}

