/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.episodes.general.FrequentEpisodes;
import ca.pfv.spmf.algorithms.episodes.minepiplus.AlgoMINEPIPlus;
import ca.pfv.spmf.algorithms.episodes.standardepisoderules.AlgoGenerateEpisodeRules;
import java.io.IOException;

public class DescriptionAlgoMINEPIPlusRules
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "MINEPI+Rules";
    }

    @Override
    public String getAlgorithmCategory() {
        return "EPISODE RULE MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/standard_episode_rules.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int minSup = DescriptionAlgoMINEPIPlusRules.getParamAsInteger(parameters[0]);
        int maxWindow = DescriptionAlgoMINEPIPlusRules.getParamAsInteger(parameters[1]);
        boolean selftIncrement = DescriptionAlgoMINEPIPlusRules.getParamAsBoolean(parameters[2]);
        AlgoMINEPIPlus algo = new AlgoMINEPIPlus();
        FrequentEpisodes frequentEpisodes = algo.runAlgorithm(inputFile, null, minSup, maxWindow, selftIncrement);
        algo.printStats();
        double minConfidence = DescriptionAlgoMINEPIPlusRules.getParamAsDouble(parameters[3]);
        int maxConsequentSize = DescriptionAlgoMINEPIPlusRules.getParamAsInteger(parameters[4]);
        AlgoGenerateEpisodeRules ruleMiner = new AlgoGenerateEpisodeRules();
        ruleMiner.runAlgorithm(frequentEpisodes, minSup, minConfidence, maxConsequentSize);
        ruleMiner.writeRulesToFileSPMFFormat(outputFile);
        ruleMiner.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minimum support", "(e.g. 2)", Integer.class, false), new DescriptionOfParameter("Max. Time duration", "(e.g. 2)", Integer.class, false), new DescriptionOfParameter("Has no timestamps?", "(default: false)", Boolean.class, false), new DescriptionOfParameter("Minimum confidence", "(e.g. 0.2)", Double.class, false), new DescriptionOfParameter("Max. consequent event count", "(e.g. 1)", Integer.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Yang Peng, Yangming Chen";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Transaction database with timestamps"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Episodes", "Episode rules"};
    }
}

