/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.frequentpatterns.MSAprioriSrinivas.AlgoMSAprioriSrinivas;

public class DescriptionAlgoMSAprioriSrinivas
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "MSApriori(Srinivas)";
    }

    @Override
    public String getAlgorithmCategory() {
        return "FREQUENT ITEMSET MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/MsApriori.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws Exception {
        double beta = DescriptionAlgoMSAprioriSrinivas.getParamAsDouble(parameters[0]);
        double ls = DescriptionAlgoMSAprioriSrinivas.getParamAsDouble(parameters[1]);
        AlgoMSAprioriSrinivas algorithm = new AlgoMSAprioriSrinivas();
        if (parameters.length >= 3 && !"".equals(parameters[2])) {
            algorithm.setMaximumPatternLength(DescriptionAlgoMSAprioriSrinivas.getParamAsInteger(parameters[2]));
        }
        int hashUpTo = 4;
        algorithm.runAlgorithm(inputFile, outputFile, beta, ls, hashUpTo);
        algorithm.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Beta", "(e.g. 0.4 or 40%)", Double.class, false), new DescriptionOfParameter("LS", "(e.g. 0.2 or 20%)", Double.class, false), new DescriptionOfParameter("Max pattern length", "(e.g. 2 items)", Integer.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Srinivas Paturu";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Simple transaction database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Frequent patterns", "Frequent itemsets", "Frequent itemsets with multiple thresholds"};
    }
}

