/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.sequentialpatterns.nosep.AlgoNOSEP;
import java.io.IOException;

public class DescriptionAlgoNOSEP
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "NOSEP";
    }

    @Override
    public String getAlgorithmCategory() {
        return "SEQUENTIAL PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/NOSEP.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int minlen = DescriptionAlgoNOSEP.getParamAsInteger(parameters[0]);
        int maxlen = DescriptionAlgoNOSEP.getParamAsInteger(parameters[1]);
        int mingap = DescriptionAlgoNOSEP.getParamAsInteger(parameters[2]);
        int maxgap = DescriptionAlgoNOSEP.getParamAsInteger(parameters[3]);
        int minsup = DescriptionAlgoNOSEP.getParamAsInteger(parameters[4]);
        AlgoNOSEP algorithm = new AlgoNOSEP();
        algorithm.runAlgorithm(inputFile, outputFile, minlen, maxlen, mingap, maxgap, minsup);
        algorithm.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Min. length", "(e.g. 1)", Integer.class, false), new DescriptionOfParameter("Max. length", "(e.g. 20)", Integer.class, false), new DescriptionOfParameter("Min. gap", "(e.g. 0)", Integer.class, false), new DescriptionOfParameter("Max. gap", "(e.g. 2)", Integer.class, false), new DescriptionOfParameter("Min. support", "(e.g. 3)", Integer.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Youxi Wu et al.";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Sequence", "Sequence database", "Simple Sequence Database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Sequential patterns", "Frequent Sequential patterns"};
    }
}

