/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.sequentialpatterns.phuspm.AlgoPHUSPM;
import java.io.IOException;

public class DescriptionAlgoPHUSPM
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "PHUSPM";
    }

    @Override
    public String getAlgorithmCategory() {
        return "HIGH-UTILITY PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/PHUSPM.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        AlgoPHUSPM algorithm = new AlgoPHUSPM();
        algorithm.runAlgorithm(inputFile, outputFile, DescriptionAlgoPHUSPM.getParamAsInteger(parameters[0]), DescriptionAlgoPHUSPM.getParamAsFloat(parameters[1]));
        algorithm.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minimum utility", "(e.g. 20)", Integer.class, false), new DescriptionOfParameter("Minimum probability", "(e.g. 1.4)", Float.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Ting Li et al.";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Sequence database", "Sequence Database with utility and probability values"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "High-utility patterns", "Sequential patterns", "High-utility patterns", "High-utility probability sequential patterns"};
    }
}

