/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.sequentialpatterns.prefixspan.AlgoPrefixSpan;
import java.io.IOException;

public class DescriptionAlgoPrefixSpan
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "PrefixSpan";
    }

    @Override
    public String getAlgorithmCategory() {
        return "SEQUENTIAL PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/PrefixSpan.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        double minsup = DescriptionAlgoPrefixSpan.getParamAsDouble(parameters[0]);
        AlgoPrefixSpan algo = new AlgoPrefixSpan();
        if (parameters.length >= 2 && !"".equals(parameters[1])) {
            algo.setMaximumPatternLength(DescriptionAlgoPrefixSpan.getParamAsInteger(parameters[1]));
        }
        if (parameters.length >= 3 && !"".equals(parameters[2])) {
            algo.setShowSequenceIdentifiers(DescriptionAlgoPrefixSpan.getParamAsBoolean(parameters[2]));
        }
        algo.runAlgorithm(inputFile, minsup, outputFile);
        algo.printStatistics();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup (%)", "(e.g. 0.4 or 40%)", Double.class, false), new DescriptionOfParameter("Max pattern length", "", Integer.class, true), new DescriptionOfParameter("Show sequence ids?", "(default: false)", Boolean.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Sequence database", "Simple Sequence Database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Sequential patterns", "Frequent Sequential patterns"};
    }
}

