/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.sequentialpatterns.prosecco.AlgoProsecco;
import java.io.IOException;

public class DescriptionAlgoProSecCo
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "ProSecCo";
    }

    @Override
    public String getAlgorithmCategory() {
        return "SEQUENTIAL PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/ProSecCo.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int blockSize = DescriptionAlgoProSecCo.getParamAsInteger(parameters[0]);
        int dbSize = DescriptionAlgoProSecCo.getParamAsInteger(parameters[1]);
        double errorTolerance = DescriptionAlgoProSecCo.getParamAsDouble(parameters[2]);
        double minsupRelative = DescriptionAlgoProSecCo.getParamAsDouble(parameters[3]);
        AlgoProsecco algo = new AlgoProsecco();
        algo.runAlgorithm(inputFile, outputFile, blockSize, dbSize, errorTolerance, minsupRelative);
        algo.printStatistics();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Block size ", "(e.g. 1)", Integer.class, false), new DescriptionOfParameter("Database size", "(e.g. 4)", Integer.class, true), new DescriptionOfParameter("Error tolerance (%)", "(e.g. 0.05)", Double.class, true), new DescriptionOfParameter("Minimum support (%)", "(e.g. 50%)", Double.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Sacha Servan-Schreiber";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Sequence database", "Simple Sequence Database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Sequential patterns", "Progressive Frequent Sequential patterns"};
    }
}

