/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.AlgoFournierViger08;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalpatterns.AlgoDim;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalsequentialpatterns.AlgoSeqDim;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalsequentialpatterns.MDSequenceDatabase;
import java.io.IOException;

public class DescriptionAlgoSeqDIMBideCharmTime
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "SeqDim_(BIDE+Charm)+time";
    }

    @Override
    public String getAlgorithmCategory() {
        return "SEQUENTIAL PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/ClosedMultiDimensional_SequentialPatternsWithTime.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        double minsup = DescriptionAlgoSeqDIMBideCharmTime.getParamAsDouble(parameters[0]);
        double minInterval = DescriptionAlgoSeqDIMBideCharmTime.getParamAsDouble(parameters[1]);
        double maxInterval = DescriptionAlgoSeqDIMBideCharmTime.getParamAsDouble(parameters[2]);
        double minWholeInterval = DescriptionAlgoSeqDIMBideCharmTime.getParamAsDouble(parameters[3]);
        double maxWholeInterval = DescriptionAlgoSeqDIMBideCharmTime.getParamAsDouble(parameters[4]);
        MDSequenceDatabase contextMDDatabase = new MDSequenceDatabase();
        contextMDDatabase.loadFile(inputFile);
        AlgoDim algoDim = new AlgoDim(false, true);
        AlgoSeqDim algoSeqDim2 = new AlgoSeqDim();
        AlgoFournierViger08 algoPrefixSpanHirateClustering = new AlgoFournierViger08(minsup, minInterval, maxInterval, minWholeInterval, maxWholeInterval, null, true, true);
        algoSeqDim2.runAlgorithm(contextMDDatabase, algoPrefixSpanHirateClustering, algoDim, true, outputFile);
        algoSeqDim2.printStatistics(contextMDDatabase.size());
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup (%)", "(e.g. 0.4 or 40%)", Double.class, false), new DescriptionOfParameter("Min time interval", "(e.g. 1 itemsets)", Double.class, false), new DescriptionOfParameter("Max time interval", "(e.g. 5 itemsets)", Double.class, false), new DescriptionOfParameter("Min whole time interval", "(e.g. 1 itemsets)", Double.class, false), new DescriptionOfParameter("Max whole time interval", "(e.g. 5 itemsets)", Double.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Sequence database", "Sequence database with timestamps", "Multi-dimensional sequence database with timestamps"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Sequential patterns", "Frequent sequential patterns", "Multi-dimensional frequent closed sequential patterns with timestamps"};
    }
}

