/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.AlgoFournierViger08;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalpatterns.AlgoDim;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalsequentialpatterns.AlgoSeqDim;
import ca.pfv.spmf.algorithms.sequentialpatterns.fournier2008_seqdim.multidimensionalsequentialpatterns.MDSequenceDatabase;
import java.io.IOException;

public class DescriptionAlgoSeqDIMPRefixSpanAprioriTime
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "SeqDim_(PrefixSpan+Apriori)+time";
    }

    @Override
    public String getAlgorithmCategory() {
        return "SEQUENTIAL PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/index.php?link=documentation.php#example14";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        double minsup = DescriptionAlgoSeqDIMPRefixSpanAprioriTime.getParamAsDouble(parameters[0]);
        double minInterval = DescriptionAlgoSeqDIMPRefixSpanAprioriTime.getParamAsDouble(parameters[1]);
        double maxInterval = DescriptionAlgoSeqDIMPRefixSpanAprioriTime.getParamAsDouble(parameters[2]);
        double minWholeInterval = DescriptionAlgoSeqDIMPRefixSpanAprioriTime.getParamAsDouble(parameters[3]);
        double maxWholeInterval = DescriptionAlgoSeqDIMPRefixSpanAprioriTime.getParamAsDouble(parameters[4]);
        MDSequenceDatabase contextMDDatabase = new MDSequenceDatabase();
        contextMDDatabase.loadFile(inputFile);
        AlgoDim algoDim = new AlgoDim(false, false);
        AlgoSeqDim algoSeqDim2 = new AlgoSeqDim();
        AlgoFournierViger08 algoPrefixSpanHirateClustering = new AlgoFournierViger08(minsup, minInterval, maxInterval, minWholeInterval, maxWholeInterval, null, false, false);
        algoSeqDim2.runAlgorithm(contextMDDatabase, algoPrefixSpanHirateClustering, algoDim, false, outputFile);
        algoSeqDim2.printStatistics(contextMDDatabase.size());
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Minsup (%)", "(e.g. 0.4 or 40%)", Double.class, false), new DescriptionOfParameter("Min time interval", "(e.g. 1 itemsets)", Double.class, false), new DescriptionOfParameter("Max time interval", "(e.g. 5 itemsets)", Double.class, false), new DescriptionOfParameter("Min whole time interval", "(e.g. 1 itemsets)", Double.class, false), new DescriptionOfParameter("Max whole time interval", "(e.g. 5 itemsets)", Double.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Sequence database", "Sequence database with timestamps", "Multi-dimensional sequence database with timestamps"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Sequential patterns", "Frequent sequential patterns", "Multi-dimensional frequent sequential patterns with timestamps"};
    }
}

