/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.episodes.emma.AlgoTKE;
import ca.pfv.spmf.algorithms.episodes.emma.EpisodeEMMA;
import ca.pfv.spmf.algorithms.episodes.standardepisoderules.AlgoGenerateEpisodeRules;
import java.io.IOException;
import java.util.PriorityQueue;

public class DescriptionAlgoTKERules
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "TKE-Rules";
    }

    @Override
    public String getAlgorithmCategory() {
        return "EPISODE RULE MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/standard_episode_rules.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int k = DescriptionAlgoTKERules.getParamAsInteger(parameters[0]);
        int maxWindow = DescriptionAlgoTKERules.getParamAsInteger(parameters[1]);
        boolean selftIncrement = DescriptionAlgoTKERules.getParamAsBoolean(parameters[2]);
        AlgoTKE algo = new AlgoTKE();
        PriorityQueue<EpisodeEMMA> frequentEpisodes = algo.runAlgorithm(inputFile, outputFile, k, maxWindow, selftIncrement);
        algo.printStats();
        double minConfidence = DescriptionAlgoTKERules.getParamAsDouble(parameters[3]);
        int maxConsequentSize = DescriptionAlgoTKERules.getParamAsInteger(parameters[4]);
        int minSupport = DescriptionAlgoTKERules.getParamAsInteger(parameters[5]);
        AlgoGenerateEpisodeRules ruleMiner = new AlgoGenerateEpisodeRules();
        ruleMiner.runAlgorithm(frequentEpisodes, minSupport, minConfidence, maxConsequentSize);
        ruleMiner.writeRulesToFileSPMFFormat(outputFile);
        ruleMiner.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("k", "(e.g. 6)", Integer.class, false), new DescriptionOfParameter("Max. Time duration", "(e.g. 2)", Integer.class, false), new DescriptionOfParameter("Has no timestamps?", "(default: false)", Boolean.class, false), new DescriptionOfParameter("Minimum confidence", "(e.g. 0.2)", Double.class, false), new DescriptionOfParameter("Max. consequent event count", "(e.g. 1)", Integer.class, false), new DescriptionOfParameter("Minimum support", "(e.g. 2)", Integer.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Yang Peng, Yangming Chen";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Transaction database with timestamps"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Episodes", "Episode rules"};
    }
}

