/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.associationrules.TopKRules_and_TNR.AlgoTNR;
import ca.pfv.spmf.algorithms.associationrules.TopKRules_and_TNR.Database;
import java.io.IOException;

public class DescriptionAlgoTNR
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "TNR";
    }

    @Override
    public String getAlgorithmCategory() {
        return "ASSOCIATION RULE MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/TopKNonRedundantAssociationRules.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        Database database = new Database();
        database.loadFile(inputFile);
        int k = DescriptionAlgoTNR.getParamAsInteger(parameters[0]);
        double minconf = DescriptionAlgoTNR.getParamAsDouble(parameters[1]);
        int delta = DescriptionAlgoTNR.getParamAsInteger(parameters[2]);
        AlgoTNR algo = new AlgoTNR();
        if (parameters.length >= 4 && !"".equals(parameters[3])) {
            algo.setMaxAntecedentSize(DescriptionAlgoTNR.getParamAsInteger(parameters[3]));
        }
        if (parameters.length >= 5 && !"".equals(parameters[4])) {
            algo.setMaxConsequentSize(DescriptionAlgoTNR.getParamAsInteger(parameters[4]));
        }
        algo.runAlgorithm(k, minconf, database, delta);
        algo.printStats();
        algo.writeResultTofile(outputFile);
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("k", "(e.g. 10)", Integer.class, false), new DescriptionOfParameter("Minconf (%)", "(e.g. 0.5 or 50%)", Double.class, false), new DescriptionOfParameter("Delta", "(e.g. 2)", Integer.class, false), new DescriptionOfParameter("Max antecedent size", "(e.g. 1 items)", Integer.class, true), new DescriptionOfParameter("Max consequent size", "(e.g. 2 items)", Integer.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Simple transaction database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Association rules", "Top-k non-redundant association rules"};
    }
}

