/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.sequentialpatterns.BIDE_and_prefixspan.AlgoTSP_nonClosed;
import ca.pfv.spmf.input.sequence_database_list_integers.SequenceDatabase;
import java.io.IOException;

public class DescriptionAlgoTSP
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "TSP_nonClosed";
    }

    @Override
    public String getAlgorithmCategory() {
        return "SEQUENTIAL PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/TSP.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int k = DescriptionAlgoTSP.getParamAsInteger(parameters[0]);
        boolean outputSeqIdentifiers = false;
        if (parameters.length >= 2 && !"".equals(parameters[1])) {
            outputSeqIdentifiers = DescriptionAlgoTSP.getParamAsBoolean(parameters[1]);
        }
        SequenceDatabase sequenceDatabase = new SequenceDatabase();
        sequenceDatabase.loadFile(inputFile);
        AlgoTSP_nonClosed algo = new AlgoTSP_nonClosed();
        algo.setShowSequenceIdentifiers(outputSeqIdentifiers);
        algo.runAlgorithm(sequenceDatabase, k);
        algo.writeResultTofile(outputFile);
        algo.printStatistics(sequenceDatabase.size());
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("k ", "(e.g. 5 patterns)", Double.class, false), new DescriptionOfParameter("Show sequence ids?", "(default: false)", Boolean.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Sequence database", "Simple sequence database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Sequential patterns", "Top-k frequent sequential patterns"};
    }
}

