/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.graph_mining.tseqminer.AlgoTSeqMiner;
import java.io.File;
import java.io.IOException;

public class DescriptionAlgoTSeqMiner
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "TSEQMINER";
    }

    @Override
    public String getAlgorithmCategory() {
        return "GRAPH PATTERN MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/TSEQMINER.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException, ClassNotFoundException {
        String inputDirectory = String.valueOf(DescriptionAlgoTSeqMiner.getParamAsString(parameters[0])) + File.separator;
        float discretizationThreshold = DescriptionAlgoTSeqMiner.getParamAsFloat(parameters[1]);
        float minInitSup = DescriptionAlgoTSeqMiner.getParamAsFloat(parameters[2]);
        int minTailSup = DescriptionAlgoTSeqMiner.getParamAsInteger(parameters[3]);
        float minSig = DescriptionAlgoTSeqMiner.getParamAsFloat(parameters[4]);
        int attributeCount = DescriptionAlgoTSeqMiner.getParamAsInteger(parameters[5]);
        AlgoTSeqMiner algo = new AlgoTSeqMiner();
        algo.runAlgorithm(inputDirectory, outputFile, discretizationThreshold, minInitSup, minTailSup, minSig, attributeCount);
        algo.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Input directory", "(e.g. DB_TSEQMINER)", String.class, false), new DescriptionOfParameter("Discretization threshold", "(e.g. 1)", Float.class, false), new DescriptionOfParameter("minInitSup", "(e.g. 0.004)", Float.class, false), new DescriptionOfParameter("minTailSup", "(e.g. 60)", Integer.class, false), new DescriptionOfParameter("minSig", "(e.g. 8.0)", Float.class, false), new DescriptionOfParameter("Attribute count", "(e.g. 43)", Integer.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Chao Cheng and Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Dynamic Attributed Graph"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Trend patterns", "Significant Trend Sequences"};
    }
}

