/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.episodes.tup.tup_combined.AlgoTUP_Combined;
import java.io.IOException;

public class DescriptionAlgoTUP_Combined
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "TUP_Combined";
    }

    @Override
    public String getAlgorithmCategory() {
        return "EPISODE MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/TUP.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int maxTimeDuration = DescriptionAlgoTUP_Combined.getParamAsInteger(parameters[0]);
        int k = DescriptionAlgoTUP_Combined.getParamAsInteger(parameters[1]);
        AlgoTUP_Combined algo = new AlgoTUP_Combined();
        algo.runAlgorithm(inputFile, maxTimeDuration, k);
        algo.writeResultTofile(outputFile);
        algo.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Max. Time duration", "(e.g. 2)", Integer.class, false), new DescriptionOfParameter("k", "(e.g. 3)", Integer.class, false)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Rathore et al.";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Database of instances", "Transaction database", "Transaction database with utility values"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Patterns", "Episodes", "High-utility patterns", "High-Utility episodes", "Top-k High-Utility episodes"};
    }
}

