/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.timeseries.TimeSeries;
import ca.pfv.spmf.algorithms.timeseries.normalization.AlgoMinMaxNormalization;
import ca.pfv.spmf.algorithms.timeseries.reader_writer.AlgoTimeSeriesReader;
import ca.pfv.spmf.algorithms.timeseries.reader_writer.AlgoTimeSeriesWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DescriptionAlgoTimeSeriesMinMaxNormalization
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "Calculate_min_max_normalization_of_time_series";
    }

    @Override
    public String getAlgorithmCategory() {
        return "TIME SERIES MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/TimeSeriesMinMaxNormalization.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        String separator = parameters.length > 1 && !"".equals(parameters[0]) ? DescriptionAlgoTimeSeriesMinMaxNormalization.getParamAsString(parameters[0]) : " ";
        AlgoTimeSeriesReader reader = new AlgoTimeSeriesReader();
        List<TimeSeries> multipleTimeSeries = reader.runAlgorithm(inputFile, separator);
        ArrayList<TimeSeries> resultMultipleTimeSeries = new ArrayList<TimeSeries>();
        for (TimeSeries timeSeries : multipleTimeSeries) {
            AlgoMinMaxNormalization algorithm = new AlgoMinMaxNormalization();
            TimeSeries result = algorithm.runAlgorithm(timeSeries);
            resultMultipleTimeSeries.add(result);
            algorithm.printStats();
        }
        AlgoTimeSeriesWriter algorithm2 = new AlgoTimeSeriesWriter();
        algorithm2.runAlgorithm(outputFile, resultMultipleTimeSeries, separator);
        algorithm2.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("separator", "(e.g. ',' , default: ' ')", String.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Time series database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Time series database"};
    }
}

