/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.timeseries.TimeSeries;
import ca.pfv.spmf.algorithms.timeseries.paa.AlgoPiecewiseAggregateApproximation;
import ca.pfv.spmf.algorithms.timeseries.reader_writer.AlgoTimeSeriesReader;
import ca.pfv.spmf.algorithms.timeseries.reader_writer.AlgoTimeSeriesWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DescriptionAlgoTimeSeriesPAA
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "Calculate_piecewise_aggregate_approx_of_time_series";
    }

    @Override
    public String getAlgorithmCategory() {
        return "TIME SERIES MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/TimeSeriesPiecewiseAggregateApproximation.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int numberOfSegments = DescriptionAlgoTimeSeriesPAA.getParamAsInteger(parameters[0]);
        String separator = parameters.length > 1 && !"".equals(parameters[1]) ? DescriptionAlgoTimeSeriesPAA.getParamAsString(parameters[1]) : " ";
        AlgoTimeSeriesReader reader = new AlgoTimeSeriesReader();
        List<TimeSeries> multipleTimeSeries = reader.runAlgorithm(inputFile, separator);
        ArrayList<TimeSeries> movingAveragemultipleTimeSeries = new ArrayList<TimeSeries>();
        for (TimeSeries timeSeries : multipleTimeSeries) {
            AlgoPiecewiseAggregateApproximation algorithm = new AlgoPiecewiseAggregateApproximation();
            TimeSeries movingAverageSeries = algorithm.runAlgorithm(timeSeries, numberOfSegments);
            movingAveragemultipleTimeSeries.add(movingAverageSeries);
            algorithm.printStats();
        }
        AlgoTimeSeriesWriter algorithm2 = new AlgoTimeSeriesWriter();
        algorithm2.runAlgorithm(outputFile, movingAveragemultipleTimeSeries, separator);
        algorithm2.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Number of segments", "(e.g. 3)", Integer.class, false), new DescriptionOfParameter("separator", "(e.g. ',' , default: ' ')", String.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Time series database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Time series database"};
    }
}

