/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithmmanager.descriptions;

import ca.pfv.spmf.algorithmmanager.DescriptionOfAlgorithm;
import ca.pfv.spmf.algorithmmanager.DescriptionOfParameter;
import ca.pfv.spmf.algorithms.timeseries.TimeSeries;
import ca.pfv.spmf.algorithms.timeseries.reader_writer.AlgoTimeSeriesReader;
import ca.pfv.spmf.algorithms.timeseries.reader_writer.AlgoTimeSeriesWriter;
import ca.pfv.spmf.algorithms.timeseries.split.AlgoSplitTimeSeries;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DescriptionAlgoTimeSeriesSplitByNumberOfSegments
extends DescriptionOfAlgorithm {
    @Override
    public String getName() {
        return "Split_time_series_by_number_of_segments";
    }

    @Override
    public String getAlgorithmCategory() {
        return "TIME SERIES MINING";
    }

    @Override
    public String getURLOfDocumentation() {
        return "http://www.philippe-fournier-viger.com/spmf/SplitTimeSeriesByNumberOfSegments.php";
    }

    @Override
    public void runAlgorithm(String[] parameters, String inputFile, String outputFile) throws IOException {
        int numberOfSeries = DescriptionAlgoTimeSeriesSplitByNumberOfSegments.getParamAsInteger(parameters[0]);
        String separator = parameters.length > 1 && !"".equals(parameters[1]) ? DescriptionAlgoTimeSeriesSplitByNumberOfSegments.getParamAsString(parameters[1]) : " ";
        AlgoTimeSeriesReader reader = new AlgoTimeSeriesReader();
        List<TimeSeries> multipleTimeSeries = reader.runAlgorithm(inputFile, separator);
        ArrayList<TimeSeries> allSplittedTimeSeries = new ArrayList<TimeSeries>(multipleTimeSeries.size() * numberOfSeries);
        for (TimeSeries timeSeries : multipleTimeSeries) {
            AlgoSplitTimeSeries algorithm = new AlgoSplitTimeSeries();
            TimeSeries[] splittedTimeSeries = algorithm.runAlgorithm(numberOfSeries, timeSeries);
            algorithm.printStats();
            TimeSeries[] timeSeriesArray = splittedTimeSeries;
            int n = splittedTimeSeries.length;
            int n2 = 0;
            while (n2 < n) {
                TimeSeries series = timeSeriesArray[n2];
                allSplittedTimeSeries.add(series);
                ++n2;
            }
        }
        AlgoTimeSeriesWriter algorithm2 = new AlgoTimeSeriesWriter();
        algorithm2.runAlgorithm(outputFile, allSplittedTimeSeries, separator);
        algorithm2.printStats();
    }

    @Override
    public DescriptionOfParameter[] getParametersDescription() {
        DescriptionOfParameter[] parameters = new DescriptionOfParameter[]{new DescriptionOfParameter("Number of segments", "(e.g. 2)", Integer.class, false), new DescriptionOfParameter("separator", "(e.g. ',' , default: ' ')", String.class, true)};
        return parameters;
    }

    @Override
    public String getImplementationAuthorNames() {
        return "Philippe Fournier-Viger";
    }

    @Override
    public String[] getInputFileTypes() {
        return new String[]{"Time series database"};
    }

    @Override
    public String[] getOutputFileTypes() {
        return new String[]{"Time series database"};
    }
}

