/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class ArraysAlgos {
    public static Comparator<int[]> comparatorItemsetSameSize = new Comparator<int[]>(){

        @Override
        public int compare(int[] itemset1, int[] itemset2) {
            int i = 0;
            while (i < itemset1.length) {
                if (itemset1[i] < itemset2[i]) {
                    return -1;
                }
                if (itemset2[i] < itemset1[i]) {
                    return 1;
                }
                ++i;
            }
            return 0;
        }
    };

    public static int[] cloneItemSetMinusOneItem(int[] itemset2, Integer itemToRemove) {
        int[] newItemset = new int[itemset2.length - 1];
        int i = 0;
        int j = 0;
        while (j < itemset2.length) {
            if (itemset2[j] != itemToRemove) {
                newItemset[i++] = itemset2[j];
            }
            ++j;
        }
        return newItemset;
    }

    public static int[] cloneItemSetMinusAnItemset(int[] itemset2, int[] itemsetToNotKeep) {
        int[] newItemset = new int[itemset2.length - itemsetToNotKeep.length];
        int i = 0;
        int j = 0;
        while (j < itemset2.length) {
            if (Arrays.binarySearch(itemsetToNotKeep, itemset2[j]) < 0) {
                newItemset[i++] = itemset2[j];
            }
            ++j;
        }
        return newItemset;
    }

    public static boolean allTheSameExceptLastItem(int[] itemset1, int[] itemset2) {
        int i = 0;
        while (i < itemset1.length - 1) {
            if (itemset1[i] != itemset2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int[] concatenate(int[] prefix, int[] suffix) {
        int[] concatenation = new int[prefix.length + suffix.length];
        System.arraycopy(prefix, 0, concatenation, 0, prefix.length);
        System.arraycopy(suffix, 0, concatenation, prefix.length, suffix.length);
        return concatenation;
    }

    public static int[] intersectTwoSortedArrays(int[] array1, int[] array2) {
        int newArraySize = array1.length < array2.length ? array1.length : array2.length;
        int[] newArray = new int[newArraySize];
        int pos1 = 0;
        int pos2 = 0;
        int posNewArray = 0;
        while (pos1 < array1.length && pos2 < array2.length) {
            if (array1[pos1] < array2[pos2]) {
                ++pos1;
                continue;
            }
            if (array2[pos2] < array1[pos1]) {
                ++pos2;
                continue;
            }
            newArray[posNewArray] = array1[pos1];
            ++posNewArray;
            ++pos1;
            ++pos2;
        }
        return Arrays.copyOfRange(newArray, 0, posNewArray);
    }

    public static boolean containsOrEquals(Integer[] itemset1, Integer[] itemset2) {
        int i = 0;
        while (i < itemset2.length) {
            block4: {
                int j = 0;
                while (j < itemset1.length) {
                    if (itemset1[j].intValue() != itemset2[i].intValue()) {
                        if (itemset1[j] > itemset2[i]) {
                            return false;
                        }
                        ++j;
                        continue;
                    }
                    break block4;
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean containsOrEquals(Short[] itemset1, Short[] itemset2) {
        int i = 0;
        while (i < itemset2.length) {
            block4: {
                int j = 0;
                while (j < itemset1.length) {
                    if (itemset1[j].shortValue() != itemset2[i].shortValue()) {
                        if (itemset1[j] > itemset2[i]) {
                            return false;
                        }
                        ++j;
                        continue;
                    }
                    break block4;
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean containsOrEquals(List<Short> itemset1, List<Short> itemset2) {
        int i = 0;
        while (i < itemset2.size()) {
            block4: {
                short val2 = itemset2.get(i);
                int j = 0;
                while (j < itemset1.size()) {
                    short val1 = itemset1.get(j);
                    if (val1 != val2) {
                        if (val1 > val2) {
                            return false;
                        }
                        ++j;
                        continue;
                    }
                    break block4;
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean containsLEX(Integer[] itemset2, Integer item, int maxItemInArray) {
        if (item > maxItemInArray) {
            return false;
        }
        Integer[] integerArray = itemset2;
        int n = itemset2.length;
        int n2 = 0;
        while (n2 < n) {
            Integer itemI = integerArray[n2];
            if (itemI.equals(item)) {
                return true;
            }
            if (itemI > item) {
                return false;
            }
            ++n2;
        }
        return false;
    }

    public static int sameAs(int[] itemset1, int[] itemsets2, int posRemoved) {
        int j = 0;
        int i = 0;
        while (i < itemset1.length) {
            if (j == posRemoved) {
                ++j;
            }
            if (itemset1[i] == itemsets2[j]) {
                ++j;
            } else {
                if (itemset1[i] > itemsets2[j]) {
                    return 1;
                }
                return -1;
            }
            ++i;
        }
        return 0;
    }

    public static boolean includedIn(int[] itemset1, int[] itemset2) {
        int count = 0;
        int i = 0;
        while (i < itemset2.length) {
            if (itemset2[i] == itemset1[count] && ++count == itemset1.length) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean includedIn(int[] itemset1, int itemset1Length, int[] itemset2) {
        int count = 0;
        int i = 0;
        while (i < itemset2.length) {
            if (itemset2[i] == itemset1[count] && ++count == itemset1Length) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsLEXPlus(int[] itemset2, int item) {
        int i = 0;
        while (i < itemset2.length) {
            if (itemset2[i] == item) {
                return true;
            }
            if (itemset2[i] > item) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsLEX(int[] itemset2, int item) {
        int i = 0;
        while (i < itemset2.length) {
            if (itemset2[i] == item) {
                return true;
            }
            if (itemset2[i] > item) {
                return false;
            }
            ++i;
        }
        return false;
    }

    public static boolean contains(int[] itemset2, int item) {
        int i = 0;
        while (i < itemset2.length) {
            if (itemset2[i] == item) {
                return true;
            }
            if (itemset2[i] > item) {
                return false;
            }
            ++i;
        }
        return false;
    }

    public static int[] appendIntegerToArray(int[] array, int integer) {
        int[] newgen = new int[array.length + 1];
        System.arraycopy(array, 0, newgen, 0, array.length);
        newgen[array.length] = integer;
        return newgen;
    }

    public static double[] convertStringArrayToDoubleArray(String[] tokens) {
        double[] numbers = new double[tokens.length];
        int i = 0;
        while (i < tokens.length) {
            String token = tokens[i];
            numbers[i] = Double.parseDouble(token);
            ++i;
        }
        return numbers;
    }

    public static boolean isSubsetOf(List<Short> itemset1, Short[] itemset2) {
        if (itemset1 == null || itemset1.size() == 0) {
            return true;
        }
        for (short val : itemset1) {
            boolean found = false;
            Short[] shortArray = itemset2;
            int n = itemset2.length;
            int n2 = 0;
            while (n2 < n) {
                short value = shortArray[n2];
                if (value > val) {
                    return false;
                }
                if (val == value) {
                    found = true;
                    break;
                }
                ++n2;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static Short[] concatenate(Short[] itemset1, Short[] itemset2) {
        Short[] concatenation = new Short[itemset1.length + itemset2.length];
        System.arraycopy(itemset1, 0, concatenation, 0, itemset1.length);
        System.arraycopy(itemset2, 0, concatenation, itemset1.length, itemset2.length);
        return concatenation;
    }
}

