/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.associationrules.fhsar;

import ca.pfv.spmf.algorithms.associationrules.fhsar.Rule;
import ca.pfv.spmf.algorithms.associationrules.fhsar.Transaction;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.stream.Collectors;

public class AlgoFHSAR {
    int tidcount = 0;
    long startTimestamp = 0L;
    long endTimeStamp = 0L;
    private int minSuppRelative;

    public void runAlgorithm(String input, String inputSAR, String output, double minsup, double minconf) throws IOException {
        String line;
        this.startTimestamp = System.currentTimeMillis();
        ArrayList<Rule> sensitiveRules = new ArrayList<Rule>();
        ArrayList<Rule> checkRules = new ArrayList<Rule>();
        ArrayList<Set<Integer>> transactions = new ArrayList<Set<Integer>>();
        PriorityQueue<Transaction> pwt = new PriorityQueue<Transaction>();
        this.readSensitiveRulesIntoMemory(inputSAR, sensitiveRules);
        BufferedReader reader = new BufferedReader(new FileReader(input));
        this.tidcount = 0;
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            String[] lineSplited = line.split(" ");
            Set<Integer> transaction = new HashSet(lineSplited.length);
            int i = 0;
            while (i < lineSplited.length) {
                int item = Integer.parseInt(lineSplited[i]);
                transaction.add(item);
                ++i;
            }
            boolean thereIsARuleSupportedByTransaction = false;
            ArrayList<Rule> rulesContained = new ArrayList<Rule>();
            block2: for (Rule rule : sensitiveRules) {
                HashSet matchLeft = new HashSet();
                HashSet<Integer> matchRight = new HashSet<Integer>();
                int i2 = 0;
                while (i2 < lineSplited.length) {
                    int item = Integer.parseInt(lineSplited[i2]);
                    if (matchLeft.size() != rule.leftSide.size() && rule.leftSide.contains(item)) {
                        matchLeft.add(item);
                        if (matchLeft.size() == rule.leftSide.size()) {
                            ++rule.leftSideCount;
                        }
                    } else if (matchRight.size() != rule.rightSide.size() && rule.rightSide.contains(item)) {
                        matchRight.add(item);
                    }
                    if (matchLeft.size() == rule.leftSide.size() && matchRight.size() == rule.rightSide.size()) {
                        ++rule.count;
                        rulesContained.add(rule);
                        thereIsARuleSupportedByTransaction = true;
                        continue block2;
                    }
                    ++i2;
                }
            }
            if (thereIsARuleSupportedByTransaction) {
                HashMap<Integer, Integer> mapItemCount = new HashMap<Integer, Integer>();
                for (Rule rule : rulesContained) {
                    for (Integer item : rule.leftSide) {
                        Integer count = (Integer)mapItemCount.get(item);
                        if (count == null) {
                            count = 0;
                        }
                        mapItemCount.put(item, count + 1);
                    }
                    for (Integer item : rule.rightSide) {
                        Integer count = (Integer)mapItemCount.get(item);
                        if (count == null) {
                            count = 0;
                        }
                        mapItemCount.put(item, count + 1);
                    }
                }
                Map itemCount = mapItemCount.entrySet().stream().sorted((o1, o2) -> ((Integer)o2.getValue()).compareTo((Integer)o1.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
                Set<Integer> setItemRank = itemCount.keySet();
                int mic = -1;
                int maxItem = -1;
                for (Map.Entry entry : mapItemCount.entrySet()) {
                    if ((Integer)entry.getValue() <= mic) continue;
                    maxItem = (Integer)entry.getKey();
                    mic = (Integer)entry.getValue();
                }
                double wi = (double)mic / Math.pow(2.0, (double)transaction.size() - 1.0);
                pwt.add(new Transaction(transaction, wi, maxItem, setItemRank));
            }
            ++this.tidcount;
            transactions.add(transaction);
        }
        reader.close();
        this.minSuppRelative = (int)Math.ceil(minsup * (double)this.tidcount);
        while (!sensitiveRules.isEmpty()) {
            double wi;
            boolean check = false;
            Transaction td = null;
            int maxItem = 0;
            block9: while (!check) {
                Transaction tdd = (Transaction)pwt.poll();
                ArrayList<Rule> checkingRules = new ArrayList<Rule>();
                for (Rule checkRule : checkRules) {
                    if (tdd.items.containsAll(checkRule.leftSide) && tdd.items.containsAll(checkRule.rightSide)) continue;
                    checkingRules.add(checkRule);
                }
                for (Integer selectedItem : tdd.setItemRank) {
                    int dem = 0;
                    for (Rule checkingRule : checkingRules) {
                        if (checkingRule.leftSide.contains(selectedItem)) break;
                        ++dem;
                    }
                    if (dem != checkingRules.size()) continue;
                    check = true;
                    maxItem = selectedItem;
                    td = tdd;
                    continue block9;
                }
            }
            HashMap<Integer, Integer> mapItemCount = new HashMap<Integer, Integer>();
            boolean atLeastOneRule = false;
            for (Rule rule : sensitiveRules) {
                Integer count;
                if (!td.items.containsAll(rule.leftSide) || !td.items.containsAll(rule.rightSide)) continue;
                if (rule.leftSide.contains(maxItem)) {
                    --rule.count;
                    --rule.leftSideCount;
                    continue;
                }
                if (rule.rightSide.contains(maxItem)) {
                    --rule.count;
                    continue;
                }
                atLeastOneRule = true;
                for (Integer item : rule.leftSide) {
                    count = (Integer)mapItemCount.get(item);
                    if (count == null) {
                        count = 0;
                    }
                    mapItemCount.put(item, count + 1);
                }
                for (Integer item : rule.rightSide) {
                    count = (Integer)mapItemCount.get(item);
                    if (count == null) {
                        count = 0;
                    }
                    mapItemCount.put(item, count + 1);
                }
            }
            td.items.remove(maxItem);
            Iterator iter = sensitiveRules.iterator();
            while (iter.hasNext()) {
                Rule rule = (Rule)iter.next();
                if (rule.count >= this.minSuppRelative && !((double)rule.count / (double)rule.leftSideCount < minconf)) continue;
                if (rule.count >= this.minSuppRelative) {
                    checkRules.add(rule);
                }
                iter.remove();
            }
            if (!atLeastOneRule) continue;
            Map itemCount = mapItemCount.entrySet().stream().sorted((o1, o2) -> ((Integer)o2.getValue()).compareTo((Integer)o1.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
            Set newsetItemRank = itemCount.keySet();
            int mic = -1;
            int newMaxItem = -1;
            for (Map.Entry entry : mapItemCount.entrySet()) {
                if ((Integer)entry.getValue() <= mic) continue;
                newMaxItem = (Integer)entry.getKey();
                mic = (Integer)entry.getValue();
            }
            td.wi = wi = (double)mic / Math.pow(2.0, (double)td.items.size() - 1.0);
            td.maxItem = newMaxItem;
            td.setItemRank = newsetItemRank;
            pwt.add(td);
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(output));
        for (Set<Integer> transaction : transactions) {
            ArrayList sorted = new ArrayList(transaction);
            Collections.sort(sorted);
            int i = 0;
            while (i < sorted.size()) {
                if (i > 0) {
                    writer.write(" " + sorted.get(i));
                } else {
                    writer.write("" + sorted.get(i));
                }
                ++i;
            }
            writer.newLine();
        }
        writer.close();
        this.endTimeStamp = System.currentTimeMillis();
    }

    private void readSensitiveRulesIntoMemory(String inputSAR, List<Rule> rules) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(inputSAR));
        while ((line = reader.readLine()) != null) {
            String string;
            String[] lineSplited = line.split("==> ");
            String[] leftStrings = lineSplited[0].split(" ");
            String[] rightStrings = lineSplited[1].split(" ");
            Rule rule = new Rule();
            String[] stringArray = leftStrings;
            int n = leftStrings.length;
            int n2 = 0;
            while (n2 < n) {
                string = stringArray[n2];
                rule.leftSide.add(Integer.parseInt(string));
                ++n2;
            }
            stringArray = rightStrings;
            n = rightStrings.length;
            n2 = 0;
            while (n2 < n) {
                string = stringArray[n2];
                if (string.length() > 0 && string.charAt(0) == '#') break;
                rule.rightSide.add(Integer.parseInt(string));
                ++n2;
            }
            rules.add(rule);
        }
        reader.close();
    }

    public void printStats() {
        System.out.println("=============  FSHAR 2.36 - STATS =============");
        System.out.println(" Transactions count from original database : " + this.tidcount);
        System.out.println(" minsup : " + this.minSuppRelative + " transactions");
        System.out.println(" Total time ~ " + (this.endTimeStamp - this.startTimestamp) + " ms");
        System.out.println("============================================");
    }
}

