/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.associationrules.gcd;

import ca.pfv.spmf.algorithms.associationrules.gcd.GCDInfo;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MyBigInteger
implements Comparable<MyBigInteger> {
    private static final int INT_MAX = Integer.MAX_VALUE;
    private BigInteger bigInteger;
    private boolean previouslyOverflowed;
    private List<Integer> factors;
    private static int combinationsElementsLimit;
    private static Set<GCDInfo> results;

    static {
        results = new HashSet<GCDInfo>();
    }

    public static void setResultsSet(Set<GCDInfo> results) {
        MyBigInteger.results = results;
    }

    public static void setCombinationsElementsLimit(int combinationsElementsLimit) {
        MyBigInteger.combinationsElementsLimit = combinationsElementsLimit;
    }

    public static MyBigInteger constructMyBigInteger_One() {
        return new MyBigInteger(1);
    }

    private MyBigInteger(Integer integer) {
        this(BigInteger.valueOf(integer.intValue()), new ArrayList<Integer>(), false);
    }

    private MyBigInteger(BigInteger bigInteger, List<Integer> factors, boolean overflowed) {
        this.bigInteger = bigInteger;
        this.previouslyOverflowed = overflowed;
        this.factors = factors;
    }

    public void multiply(int input) {
        long longMultiplication;
        this.factors.add(input);
        Collections.sort(this.factors);
        if (!this.previouslyOverflowed && (longMultiplication = this.bigInteger.longValue() * (long)input) > 0L) {
            this.bigInteger = BigInteger.valueOf(longMultiplication);
            return;
        }
        this.bigInteger = this.bigInteger.multiply(BigInteger.valueOf(input));
        this.previouslyOverflowed = true;
    }

    public boolean isDivisibleBy(MyBigInteger other) {
        if (this.factors.size() < other.factors.size()) {
            return false;
        }
        for (Integer factorInOther : other.factors) {
            if (this.factors.indexOf(factorInOther) != -1) continue;
            return false;
        }
        return true;
    }

    public MyBigInteger divide(MyBigInteger other) {
        if (this.factors.size() < other.factors.size()) {
            return null;
        }
        MyBigInteger result = new MyBigInteger(1);
        ArrayList<Integer> factorsCopy = new ArrayList<Integer>(this.factors);
        for (Integer factorInOther : other.factors) {
            int index = factorsCopy.indexOf(factorInOther);
            if (index == -1) {
                return null;
            }
            factorsCopy.set(index, null);
        }
        for (Integer factor : factorsCopy) {
            if (factor == null) continue;
            result.multiply(factor);
        }
        return result;
    }

    private static void harvestGCDs(Set<MyBigInteger> GCDs) {
        for (MyBigInteger gcd : GCDs) {
            MyBigInteger.harvestGCD(gcd);
        }
    }

    public static void harvestGCD(MyBigInteger gcd) {
        GCDInfo gcdInfo = new GCDInfo(gcd);
        if (!results.contains(gcdInfo)) {
            MyBigInteger.harvestGCD(gcdInfo);
        }
    }

    private static synchronized void harvestGCD(GCDInfo gcd) {
        results.add(gcd);
    }

    public void calcAndHarvestGCDs(MyBigInteger other) {
        HashSet<MyBigInteger> combinationsOfK = new HashSet<MyBigInteger>();
        int i = 0;
        int j = 0;
        Integer intFrom1stList = this.factors.get(i);
        Integer intFrom2ndList = other.factors.get(j);
        int firstListSize = this.factors.size();
        int secondListSize = other.factors.size();
        ArrayList<Integer> commonFactors = new ArrayList<Integer>();
        while (true) {
            if (intFrom1stList > intFrom2ndList) {
                if (++j >= secondListSize) break;
                intFrom2ndList = other.factors.get(j);
                continue;
            }
            if (intFrom1stList < intFrom2ndList) {
                if (++i >= firstListSize) break;
                intFrom1stList = this.factors.get(i);
                continue;
            }
            commonFactors.add(intFrom1stList);
            if (++i >= firstListSize || ++j >= secondListSize) break;
            intFrom2ndList = other.factors.get(j);
            intFrom1stList = this.factors.get(i);
        }
        MyBigInteger gcd1 = new MyBigInteger(1);
        MyBigInteger gcd2 = new MyBigInteger(1);
        int commonFactorsSize = commonFactors.size();
        int lastElementLocation = commonFactorsSize - 1;
        i = 0;
        while (i < commonFactorsSize) {
            Integer firstFactor = (Integer)commonFactors.get(i);
            gcd1.multiply(firstFactor);
            MyBigInteger.harvestGCD(gcd1.copy());
            if (i != lastElementLocation) {
                gcd2.multiply((Integer)commonFactors.get(lastElementLocation - i));
                MyBigInteger.harvestGCD(gcd2.copy());
            }
            if (i != 0 && i != lastElementLocation) {
                ArrayList<Integer> combinationFactors = new ArrayList<Integer>();
                combinationFactors.add(firstFactor);
                MyBigInteger.harvestGCD(new MyBigInteger(BigInteger.valueOf(firstFactor.intValue()), combinationFactors, false));
            }
            if (combinationsElementsLimit > 1) {
                j = i + 1;
                while (j < commonFactorsSize) {
                    MyBigInteger combinationOfTwo = new MyBigInteger(1);
                    combinationOfTwo.multiply(firstFactor);
                    combinationOfTwo.multiply((Integer)commonFactors.get(j));
                    combinationsOfK.add(combinationOfTwo);
                    ++j;
                }
            }
            ++i;
        }
        int combinationSlots = 3;
        while (combinationsElementsLimit > 2 && combinationSlots <= combinationsElementsLimit) {
            MyBigInteger.harvestGCDs(combinationsOfK);
            ArrayList<MyBigInteger> previousCombinationsOfK = new ArrayList<MyBigInteger>(combinationsOfK);
            combinationsOfK.clear();
            for (MyBigInteger previousCombination : previousCombinationsOfK) {
                Integer biggestFactor = previousCombination.getFactors().get(previousCombination.getFactors().size() - 1);
                for (Integer commonFactor : commonFactors) {
                    if (commonFactor <= biggestFactor) continue;
                    MyBigInteger newCombination = previousCombination.copy();
                    newCombination.multiply(commonFactor);
                    combinationsOfK.add(newCombination);
                }
            }
            ++combinationSlots;
        }
        MyBigInteger.harvestGCDs(combinationsOfK);
    }

    private MyBigInteger copy() {
        return new MyBigInteger(this.bigInteger.add(BigInteger.ZERO), new ArrayList<Integer>(this.factors), this.previouslyOverflowed);
    }

    public List<Integer> getFactors() {
        return this.factors;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MyBigInteger) {
            return this.bigInteger.equals(((MyBigInteger)obj).bigInteger);
        }
        if (obj instanceof BigInteger) {
            return this.bigInteger.equals(obj);
        }
        if (obj instanceof Long) {
            return ((Long)obj).equals(this.bigInteger.longValue());
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).equals(this.bigInteger.intValue());
        }
        if (obj instanceof GCDInfo) {
            return this.equals(((GCDInfo)obj).getGCD());
        }
        return false;
    }

    public int hashCode() {
        return this.bigInteger.mod(BigInteger.valueOf(Integer.MAX_VALUE)).intValue();
    }

    public String toString() {
        return this.factors.toString();
    }

    @Override
    public int compareTo(MyBigInteger other) {
        return this.bigInteger.compareTo(other.bigInteger);
    }
}

