/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.acac;

import ca.pfv.spmf.algorithms.classifiers.acac.RuleACAC;
import ca.pfv.spmf.algorithms.classifiers.data.Dataset;
import ca.pfv.spmf.algorithms.classifiers.data.Instance;
import ca.pfv.spmf.algorithms.classifiers.general.Item;
import ca.pfv.spmf.algorithms.classifiers.general.Rule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AprioriForACAC {
    public List<RuleACAC> run(Dataset dataset, double minSup, double minConf, double minAllConf) {
        long minSupRelative = (long)Math.ceil(minSup * (double)dataset.getInstances().size());
        ArrayList<RuleACAC> rules = new ArrayList<RuleACAC>();
        List<Item> frequent1 = this.generateSingletons(dataset, minSupRelative);
        if (frequent1.isEmpty()) {
            return new ArrayList<RuleACAC>();
        }
        Collections.sort(frequent1, new Comparator<Item>(){

            @Override
            public int compare(Item o1, Item o2) {
                return o1.item - o2.item;
            }
        });
        List<RuleACAC> level = null;
        int k = 2;
        do {
            level = k == 2 ? this.generateAndTestCandidateSize2(dataset, minConf, minAllConf, minSupRelative, rules, frequent1) : this.generateAndTestCandidateSizeK(dataset, minConf, minAllConf, minSupRelative, rules, level);
            ++k;
        } while (!level.isEmpty());
        return rules;
    }

    private List<RuleACAC> generateAndTestCandidateSizeK(Dataset dataset, double minConf, double minAllConf, long minSupRelative, List<RuleACAC> rules, List<RuleACAC> level) {
        List<RuleACAC> previousLevel = level;
        level = new ArrayList<RuleACAC>();
        int i = 0;
        while (i < previousLevel.size()) {
            RuleACAC rule1 = previousLevel.get(i);
            int j = i + 1;
            while (j < previousLevel.size()) {
                RuleACAC rule2 = previousLevel.get(j);
                if (rule1.isCombinable(rule2)) {
                    RuleACAC newRule = new RuleACAC(rule1);
                    newRule.add(rule2.get(rule2.size() - 1));
                    newRule.setMaximums(rule1.getSupportRule(), rule2.getSupportRule());
                    if (this.areSubsetsFrequents(newRule, previousLevel)) {
                        newRule.evaluate(dataset);
                        if (newRule.getSupportRule() >= minSupRelative && newRule.getAllConfidence() >= minAllConf) {
                            if (newRule.getConfidence() >= minConf) {
                                rules.add(newRule);
                            } else {
                                level.add(newRule);
                            }
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return level;
    }

    private List<RuleACAC> generateAndTestCandidateSize2(Dataset dataset, double minConf, double minAllConf, long minSupRelative, List<RuleACAC> rules, List<Item> frequent1) {
        ArrayList<RuleACAC> level = new ArrayList<RuleACAC>();
        for (Item item1 : frequent1) {
            short[] antecedent = new short[]{item1.item};
            int j = 0;
            while (j < dataset.getClassesCount()) {
                short klass = dataset.getKlassAt(j);
                long supportKlass = dataset.getMapClassToFrequency().getOrDefault(klass, 0L);
                RuleACAC rule = new RuleACAC(antecedent);
                rule.setKlass(klass);
                rule.setMaximums(item1.support, supportKlass);
                rule.evaluate(dataset);
                if (rule.getSupportRule() >= minSupRelative && rule.getAllConfidence() >= minAllConf) {
                    if (rule.getConfidence() >= minConf) {
                        rules.add(rule);
                    } else {
                        level.add(rule);
                    }
                }
                ++j;
            }
        }
        return level;
    }

    private List<Item> generateSingletons(Dataset dataset, double minSupRelative) {
        HashMap<Short, Long> mapItemCount = new HashMap<Short, Long>();
        for (Instance instance : dataset.getInstances()) {
            Short[] example = instance.getItems();
            int j = 0;
            while (j < example.length - 1) {
                short item = example[j];
                long count = mapItemCount.getOrDefault(item, 0L);
                mapItemCount.put(item, ++count);
                ++j;
            }
        }
        ArrayList<Item> frequent1 = new ArrayList<Item>();
        for (Map.Entry entry : mapItemCount.entrySet()) {
            if (!((double)((Long)entry.getValue()).longValue() >= minSupRelative)) continue;
            frequent1.add(new Item((Short)entry.getKey(), (Long)entry.getValue()));
        }
        return frequent1;
    }

    protected boolean areSubsetsFrequents(Rule candidate, List<RuleACAC> levelK1) {
        int positionToRemove = 0;
        while (positionToRemove < candidate.getAntecedent().size()) {
            boolean found = false;
            for (RuleACAC rule : levelK1) {
                if (this.sameAs(rule.getAntecedent(), candidate.getAntecedent(), positionToRemove) != 0) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
            ++positionToRemove;
        }
        return true;
    }

    int sameAs(List<Short> itemset1, List<Short> itemsets2, int posRemoved) {
        int j = 0;
        int i = 0;
        while (i < itemset1.size()) {
            if (j == posRemoved) {
                ++j;
            }
            if (itemset1.get(i).equals(itemsets2.get(j))) {
                ++j;
            } else {
                if (itemset1.get(i) > itemsets2.get(j)) {
                    return 1;
                }
                return -1;
            }
            ++i;
        }
        return 0;
    }
}

