/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.acac;

import ca.pfv.spmf.algorithms.ArraysAlgos;
import ca.pfv.spmf.algorithms.classifiers.data.Dataset;
import ca.pfv.spmf.algorithms.classifiers.data.Instance;
import ca.pfv.spmf.algorithms.classifiers.general.Rule;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class RuleACAC
extends Rule
implements Serializable {
    private static final long serialVersionUID = 9068577561757816896L;
    private long supportMax;
    private Map<Short, Long> supportRuleByKlass;

    public RuleACAC(short[] antecedent) {
        this.add(antecedent);
        this.supportRuleByKlass = new HashMap<Short, Long>();
    }

    public RuleACAC(RuleACAC rule) {
        super(rule.klass);
        this.add(rule.antecedent);
        this.supportAntecedent = rule.supportAntecedent;
        this.supportKlass = rule.supportKlass;
        this.supportRule = rule.supportRule;
        this.supportMax = rule.supportMax;
        this.supportRuleByKlass = new HashMap<Short, Long>(rule.supportRuleByKlass);
    }

    public void evaluate(Dataset train) {
        this.supportAntecedent = 0L;
        this.supportRule = 0L;
        this.supportKlass = 0L;
        for (Instance instance : train.getInstances()) {
            boolean matchAntecedent;
            boolean matchConsequent;
            Short[] items = instance.getItems();
            short instanceKlass = instance.getKlass();
            boolean bl = matchConsequent = instanceKlass == this.klass;
            if (matchConsequent) {
                ++this.supportKlass;
            }
            if (matchAntecedent = ArraysAlgos.isSubsetOf(this.antecedent, items)) {
                ++this.supportAntecedent;
            }
            if (!matchAntecedent || !matchConsequent) continue;
            ++this.supportRule;
            long count = this.supportRuleByKlass.getOrDefault(instanceKlass, 0L);
            this.supportRuleByKlass.put(instanceKlass, count + 1L);
        }
    }

    public double getAllConfidence() {
        if (this.getAntecedent().size() == 1) {
            return 1.0;
        }
        if (this.supportMax <= 0L) {
            return Double.NaN;
        }
        return (double)this.supportRule / (double)this.supportMax;
    }

    void setMaximums(long supportRule1, long supportRule2) {
        this.supportMax = Long.max(supportRule1, supportRule2);
    }

    public long getSupportByKlass(short klass) {
        return this.supportRuleByKlass.getOrDefault(klass, 0L);
    }

    @Override
    public String getMeasuresToString() {
        return " #SUP: " + this.getSupportRule() + " #CONF: " + this.getConfidence() + " #ALLCONF: " + this.getAllConfidence();
    }
}

