/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.accf;

import ca.pfv.spmf.algorithms.classifiers.accf.ItemsetACCF;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class SupersetTable {
    private List<ItemsetACCF>[] table = new ArrayList[1];

    public boolean isSuperset(ItemsetACCF itemset2, BitSet bitset) {
        int hashcode = this.calculateHashCode(bitset);
        if (this.table[hashcode] == null) {
            return true;
        }
        for (ItemsetACCF currentItemset : this.table[hashcode]) {
            if (currentItemset.getSupport() != itemset2.getSupport() || !currentItemset.containsAll(itemset2)) continue;
            return false;
        }
        return true;
    }

    public void add(ItemsetACCF itemset2, BitSet bitset) {
        int hashcode = this.calculateHashCode(bitset);
        if (this.table[hashcode] == null) {
            this.table[hashcode] = new ArrayList<ItemsetACCF>();
        }
        this.table[hashcode].add(itemset2);
    }

    private int calculateHashCode(BitSet bitset) {
        int hashCode = 0;
        int bid = bitset.nextSetBit(0);
        while (bid >= 0) {
            hashCode += bid;
            bid = bitset.nextSetBit(bid + 1);
        }
        if (hashCode < 0) {
            hashCode *= -1;
        }
        return hashCode % this.table.length;
    }
}

