/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.acn;

import ca.pfv.spmf.algorithms.classifiers.acn.RuleACN;
import ca.pfv.spmf.algorithms.classifiers.data.Dataset;
import ca.pfv.spmf.algorithms.classifiers.data.Instance;
import ca.pfv.spmf.algorithms.classifiers.general.Item;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AprioriNegativeForACN {
    private long minSupRelative;
    double minConf;
    private Dataset dataset;

    public AprioriNegativeForACN(Dataset dataset, double minSup, double minConf) {
        this.dataset = dataset;
        this.minConf = minConf;
        this.minSupRelative = (long)Math.ceil(minSup * (double)dataset.getInstances().size());
    }

    public List<RuleACN> run() {
        ArrayList<RuleACN> rules = new ArrayList<RuleACN>();
        ArrayList<RuleACN> negativeRules = new ArrayList<RuleACN>();
        List<Item> frequent1 = this.generateSingletons();
        if (frequent1.isEmpty()) {
            return new ArrayList<RuleACN>();
        }
        Collections.sort(frequent1, new Comparator<Item>(){

            @Override
            public int compare(Item o1, Item o2) {
                return o1.item - o2.item;
            }
        });
        List<RuleACN> levelK = null;
        int k = 2;
        do {
            levelK = k == 2 ? this.generateAndTestCandidateSize2(rules, negativeRules, frequent1) : this.generateAndTestCandidateSizeK(rules, negativeRules, levelK);
            ++k;
        } while (!levelK.isEmpty());
        rules.addAll(negativeRules);
        return rules;
    }

    private List<RuleACN> generateAndTestCandidateSizeK(List<RuleACN> rules, List<RuleACN> negativeRules, List<RuleACN> level) {
        ArrayList<RuleACN> levelX = new ArrayList<RuleACN>();
        int i = 0;
        while (i < level.size()) {
            RuleACN rule1 = level.get(i);
            int j = i + 1;
            while (j < level.size()) {
                RuleACN rule2 = level.get(j);
                if (rule1.isCombinable(rule2)) {
                    RuleACN newRule = new RuleACN(rule1);
                    newRule.add(rule2.get(rule2.size() - 1));
                    if (this.areSubsetsFrequents(newRule, level)) {
                        newRule.evaluate(this.dataset);
                        this.evaluateCandidate(rules, negativeRules, levelX, newRule);
                    }
                }
                ++j;
            }
            ++i;
        }
        return levelX;
    }

    private List<RuleACN> generateAndTestCandidateSize2(List<RuleACN> rules, List<RuleACN> negativeRules, List<Item> frequent1) {
        ArrayList<RuleACN> level = new ArrayList<RuleACN>();
        int i = 0;
        while (i < frequent1.size()) {
            Item item1 = frequent1.get(i);
            short[] antecedent = new short[]{item1.item};
            ArrayList<Boolean> negativeItems = new ArrayList<Boolean>();
            negativeItems.add(false);
            int j = 0;
            while (j < this.dataset.getClassesCount()) {
                RuleACN newRule = new RuleACN(antecedent, negativeItems, this.dataset.getKlassAt(j));
                newRule.evaluate(this.dataset);
                this.evaluateCandidate(rules, negativeRules, level, newRule);
                ++j;
            }
            ++i;
        }
        return level;
    }

    private void evaluateCandidate(List<RuleACN> rules, List<RuleACN> negativeRules, List<RuleACN> level, RuleACN newRule) {
        if (newRule.getSupportRule() >= this.minSupRelative) {
            level.add(newRule);
            rules.add(newRule);
            int m = 0;
            while (m < newRule.getAntecedent().size()) {
                RuleACN negatedRule = new RuleACN(newRule);
                negatedRule.negateItem(m);
                negatedRule.evaluate(this.dataset);
                if (negatedRule.getSupportRule() >= this.minSupRelative) {
                    negativeRules.add(negatedRule);
                }
                ++m;
            }
        }
    }

    private List<Item> generateSingletons() {
        HashMap<Short, Long> mapItemCount = new HashMap<Short, Long>();
        for (Instance instance : this.dataset.getInstances()) {
            Short[] items = instance.getItems();
            int j = 0;
            while (j < items.length - 1) {
                short item = items[j];
                Long count = mapItemCount.getOrDefault(item, 0L);
                count = count + 1L;
                mapItemCount.put(item, count);
                ++j;
            }
        }
        ArrayList<Item> frequent1 = new ArrayList<Item>();
        for (Map.Entry entry : mapItemCount.entrySet()) {
            if ((Long)entry.getValue() < this.minSupRelative) continue;
            frequent1.add(new Item((Short)entry.getKey(), (Long)entry.getValue()));
        }
        return frequent1;
    }

    protected boolean areSubsetsFrequents(RuleACN candidate, List<RuleACN> levelK1) {
        int positionToRemove = 0;
        while (positionToRemove < candidate.getAntecedent().size()) {
            boolean found = false;
            for (RuleACN rule : levelK1) {
                if (this.sameAs(rule.getAntecedent(), candidate.getAntecedent(), positionToRemove) != 0) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
            ++positionToRemove;
        }
        return true;
    }

    int sameAs(List<Short> itemset1, List<Short> itemsets2, int posRemoved) {
        int j = 0;
        int i = 0;
        while (i < itemset1.size()) {
            if (j == posRemoved) {
                ++j;
            }
            if (itemset1.get(i).equals(itemsets2.get(j))) {
                ++j;
            } else {
                if (itemset1.get(i) > itemsets2.get(j)) {
                    return 1;
                }
                return -1;
            }
            ++i;
        }
        return 0;
    }
}

