/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.acn;

import ca.pfv.spmf.algorithms.classifiers.acn.RuleACN;
import ca.pfv.spmf.algorithms.classifiers.data.Dataset;
import ca.pfv.spmf.algorithms.classifiers.data.Instance;
import ca.pfv.spmf.algorithms.classifiers.general.RuleClassifier;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class ClassifierACN
extends RuleClassifier
implements Serializable {
    private static final long serialVersionUID = 1486255234410043031L;

    public ClassifierACN(List<RuleACN> rules, Dataset training, double minConf, double minAcc, double minCorr) {
        super("ACN");
        Collections.sort(rules, new Comparator<RuleACN>(){

            @Override
            public int compare(RuleACN arg0, RuleACN arg1) {
                if (Double.compare(arg0.getConfidence(), arg1.getConfidence()) != 0) {
                    return -Double.compare(arg0.getConfidence(), arg1.getConfidence());
                }
                if (Double.compare(arg0.getPearson(), arg1.getPearson()) != 0) {
                    return -Double.compare(arg0.getPearson(), arg1.getPearson());
                }
                if (Double.compare(arg0.getSupportRule(), arg1.getSupportRule()) != 0) {
                    return -Double.compare(arg0.getSupportRule(), arg1.getSupportRule());
                }
                if (Integer.compare(arg0.getNegativeItems(), arg1.getNegativeItems()) != 0) {
                    return -Double.compare(arg0.getNegativeItems(), arg1.getNegativeItems());
                }
                return -Integer.compare(arg0.size(), arg1.size());
            }
        });
        ArrayList<Integer> instancesCoveredByRule = new ArrayList<Integer>();
        ArrayList<Boolean> coveredInstances = new ArrayList<Boolean>(Arrays.asList(new Boolean[training.getInstances().size()]));
        Collections.fill(coveredInstances, Boolean.FALSE);
        List<Instance> instances = training.getInstances();
        int i = 0;
        while (i < rules.size() && coveredInstances.stream().filter(p -> p == false).findFirst().isPresent()) {
            RuleACN rule2 = rules.get(i);
            int j = 0;
            while (j < instances.size()) {
                if (!((Boolean)coveredInstances.get(j)).booleanValue() && rule2.matching(instances.get(j).getItems())) {
                    instancesCoveredByRule.add(j);
                }
                ++j;
            }
            if (!(instancesCoveredByRule.isEmpty() || rule2.isANegativeRule() && !(this.getAccurracyRemainingDataset(rule2, training, coveredInstances) >= minAcc))) {
                this.rules.add(rule2);
                int m = 0;
                while (m < instancesCoveredByRule.size()) {
                    int indexInstance = (Integer)instancesCoveredByRule.get(m);
                    coveredInstances.set(indexInstance, true);
                    ++m;
                }
            }
            ++i;
        }
        HashMap<Short, Long> counterByKlass = new HashMap<Short, Long>();
        int i2 = 0;
        while (i2 < training.getInstances().size()) {
            if (!((Boolean)coveredInstances.get(i2)).booleanValue()) {
                short klass = instances.get(i2).getKlass();
                Long count = counterByKlass.getOrDefault(klass, 0L);
                counterByKlass.put(klass, count + 1L);
            }
            ++i2;
        }
        short defaultKlass = counterByKlass.isEmpty() ? Collections.max(training.getMapClassToFrequency().entrySet(), (entry1, entry2) -> ((Long)entry1.getValue()).compareTo((Long)entry2.getValue())).getKey().shortValue() : ((Short)Collections.max(counterByKlass.entrySet(), (entry1, entry2) -> ((Long)entry1.getValue()).compareTo((Long)entry2.getValue())).getKey()).shortValue();
        this.rules.removeIf(rule -> rule.getConfidence() < minConf);
        this.rules.removeIf(rule -> ((RuleACN)rule).getPearson() < minCorr);
        this.rules.add(new RuleACN(defaultKlass));
    }

    private double getAccurracyRemainingDataset(RuleACN rule, Dataset dataset, List<Boolean> coveredInstances) {
        double accuracy = 0.0;
        int numberNotCoveredInstances = 0;
        List<Instance> instances = dataset.getInstances();
        int i = 0;
        while (i < instances.size()) {
            if (!coveredInstances.get(i).booleanValue()) {
                Instance instance = instances.get(i);
                if (rule.getKlass() == instance.getKlass().shortValue() && rule.matching(instance.getItems())) {
                    accuracy += 1.0;
                }
                ++numberNotCoveredInstances;
            }
            ++i;
        }
        return accuracy / (double)numberNotCoveredInstances;
    }
}

