/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.acn;

import ca.pfv.spmf.algorithms.ArraysAlgos;
import ca.pfv.spmf.algorithms.classifiers.data.Dataset;
import ca.pfv.spmf.algorithms.classifiers.data.Instance;
import ca.pfv.spmf.algorithms.classifiers.general.Rule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class RuleACN
extends Rule
implements Serializable {
    private static final long serialVersionUID = 5182408138874851612L;
    private List<Boolean> negatedItems;
    private double pearson;

    public RuleACN() {
        this.pearson = Double.NaN;
        this.negatedItems = new ArrayList<Boolean>();
    }

    public RuleACN(RuleACN rule) {
        super(rule.klass);
        this.add(rule.antecedent);
        this.supportAntecedent = rule.supportAntecedent;
        this.supportKlass = rule.supportKlass;
        this.supportRule = rule.supportRule;
        this.negatedItems = new ArrayList<Boolean>(rule.negatedItems);
    }

    public RuleACN(short[] antecedent, List<Boolean> negativeItems, short klass) {
        super(klass);
        this.add(antecedent);
        this.pearson = Double.NaN;
        this.negatedItems = new ArrayList<Boolean>(negativeItems);
    }

    public RuleACN(short klass) {
        super(klass);
        this.negatedItems = new ArrayList<Boolean>();
    }

    public void evaluate(Dataset train) {
        this.supportAntecedent = 0L;
        this.supportRule = 0L;
        this.supportKlass = 0L;
        for (Instance instance : train.getInstances()) {
            Short[] items = instance.getItems();
            Boolean matchAntecedent = this.matching(items);
            Boolean matchConsequent = instance.getKlass() == this.klass;
            if (matchConsequent.booleanValue()) {
                ++this.supportKlass;
            }
            if (matchAntecedent.booleanValue()) {
                ++this.supportAntecedent;
            }
            if (!matchAntecedent.booleanValue() || !matchConsequent.booleanValue()) continue;
            ++this.supportRule;
        }
        double supR = (double)this.supportRule / (double)train.getInstances().size();
        double supA = (double)this.supportAntecedent / (double)train.getInstances().size();
        double supK = (double)this.supportKlass / (double)train.getInstances().size();
        double notSupA = 1.0 - supA;
        double notSupK = 1.0 - supK;
        this.pearson = (supR - supA * supK) / Math.sqrt(supA * supK * notSupA * notSupK);
    }

    @Override
    public void add(short[] item) {
        super.add(item);
        this.negatedItems = new ArrayList<Boolean>();
        int i = 0;
        while (i < item.length) {
            this.negatedItems.add(false);
            ++i;
        }
    }

    @Override
    public void add(short item) {
        super.add(item);
        this.negatedItems.add(false);
    }

    public void negateItem(int index) {
        this.negatedItems.set(index, true);
    }

    public double getPearson() {
        return this.pearson;
    }

    public int getNegativeItems() {
        return (int)this.negatedItems.stream().filter(p -> p).count();
    }

    @Override
    public boolean matching(Short[] example) {
        if (this.antecedent.isEmpty()) {
            return true;
        }
        if (!this.isANegativeRule()) {
            return super.matching(example);
        }
        ArrayList<Short> positiveAntecedent = new ArrayList<Short>();
        int i = 0;
        while (i < this.antecedent.size()) {
            if (this.negatedItems.get(i).booleanValue()) {
                short negativeItem = (Short)this.antecedent.get(i);
                Short[] shortArray = example;
                int n = example.length;
                int n2 = 0;
                while (n2 < n) {
                    short element = shortArray[n2];
                    if (element == negativeItem) {
                        return false;
                    }
                    ++n2;
                }
            } else {
                positiveAntecedent.add((Short)this.antecedent.get(i));
            }
            ++i;
        }
        return ArraysAlgos.isSubsetOf(positiveAntecedent, example);
    }

    @Override
    public boolean isIthAntecedentItemNegative(int i) {
        return this.negatedItems.get(i);
    }

    @Override
    public boolean isANegativeRule() {
        return this.getNegativeItems() > 0;
    }

    @Override
    public String getMeasuresToString() {
        return " #SUP: " + this.getSupportRule() + " #CONF: " + this.getConfidence() + " #PEARSON: " + this.getPearson();
    }
}

