/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.adt;

import ca.pfv.spmf.algorithms.ArraysAlgos;
import ca.pfv.spmf.algorithms.classifiers.adt.RuleADT;
import java.util.ArrayList;
import java.util.List;

public class ADNode
implements Cloneable {
    ADNode parent = null;
    RuleADT rule = null;
    List<ADNode> childs = new ArrayList<ADNode>();

    public ADNode(RuleADT rule) {
        this.rule = rule;
        this.parent = null;
    }

    public ADNode(ADNode node) {
        this.rule = new RuleADT(node.rule);
        this.parent = null;
        this.parent = node.parent;
        this.childs = new ArrayList<ADNode>(node.childs);
    }

    public ADNode isChild(RuleADT rule) {
        ADNode child = null;
        int i = 0;
        while (i < this.childs.size() && child == null) {
            if (ArraysAlgos.containsOrEquals(rule.getAntecedent(), this.childs.get((int)i).rule.getAntecedent())) {
                child = this.childs.get(i);
            }
            ++i;
        }
        return child;
    }

    public boolean equals(Object v) {
        boolean retVal = false;
        if (v instanceof ADNode) {
            ADNode ptr = (ADNode)v;
            retVal = ptr.rule.equals(this.rule) && ptr.parent == this.parent;
        }
        return retVal;
    }

    public int hashCode() {
        return this.rule.hashCode();
    }
}

