/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.cba;

import ca.pfv.spmf.algorithms.classifiers.cba.AprioriForCBA;
import ca.pfv.spmf.algorithms.classifiers.cba.AprioriForCBA2;
import ca.pfv.spmf.algorithms.classifiers.cba.CBAM2;
import ca.pfv.spmf.algorithms.classifiers.cba.RuleCBA;
import ca.pfv.spmf.algorithms.classifiers.data.Dataset;
import ca.pfv.spmf.algorithms.classifiers.general.ClassificationAlgorithm;
import ca.pfv.spmf.algorithms.classifiers.general.Classifier;
import java.util.List;

public class AlgoCBA
extends ClassificationAlgorithm {
    double minSup = 0.0;
    double minConf = 0.0;
    boolean shouldRunCBA2;

    public AlgoCBA(double minSup, double minConf, boolean shouldRunCBA2) {
        this.minSup = minSup;
        this.minConf = minConf;
        this.shouldRunCBA2 = shouldRunCBA2;
    }

    @Override
    public Classifier train(Dataset training) {
        List<RuleCBA> rules = this.shouldRunCBA2 ? new AprioriForCBA2().runAlgorithm(training, this.minSup, this.minConf) : new AprioriForCBA().runAlgorithm(training, this.minSup, this.minConf);
        CBAM2 cba = new CBAM2(training, rules);
        return cba.getClassifier(this.getName());
    }

    @Override
    public String getName() {
        return this.shouldRunCBA2 ? "CBA2" : "CBA";
    }
}

