/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.cba;

import ca.pfv.spmf.algorithms.classifiers.cba.Replace;
import ca.pfv.spmf.algorithms.classifiers.cba.RuleCBA;
import ca.pfv.spmf.algorithms.classifiers.cba.SelectedRule;
import ca.pfv.spmf.algorithms.classifiers.cba.Structure;
import ca.pfv.spmf.algorithms.classifiers.data.Dataset;
import ca.pfv.spmf.algorithms.classifiers.data.Instance;
import ca.pfv.spmf.algorithms.classifiers.general.RuleClassifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CBAM2 {
    private List<RuleCBA> listU;
    private List<RuleCBA> listQ;
    private List<SelectedRule> listC;
    private List<Structure> listA;
    private Dataset dataset;
    private List<RuleCBA> rules;

    public CBAM2(Dataset dataset, List<RuleCBA> rules) {
        this.dataset = dataset;
        this.rules = rules;
        this.listU = new ArrayList<RuleCBA>();
        this.listQ = new ArrayList<RuleCBA>();
        this.listA = new ArrayList<Structure>();
        Collections.sort(this.rules);
        this.stage1();
        this.stage2();
        this.stage3();
    }

    private void stage1() {
        int i = 0;
        while (i < this.dataset.getInstances().size()) {
            RuleCBA rule;
            Instance instance = this.dataset.getInstances().get(i);
            Short[] items = instance.getItems();
            short y = instance.getKlass();
            int cRule = -1;
            int wRule = -1;
            int j = 0;
            while (j < this.rules.size() && (cRule < 0 || wRule < 0)) {
                rule = this.rules.get(j);
                if (rule.matching(items)) {
                    if (cRule < 0 && y == rule.getKlass()) {
                        cRule = j;
                    }
                    if (wRule < 0 && y != rule.getKlass()) {
                        wRule = j;
                    }
                }
                ++j;
            }
            if (cRule > -1) {
                rule = this.rules.get(cRule);
                if (this.isNew(this.listU, rule)) {
                    this.listU.add(rule);
                }
                rule.incrementKlassCovered(y);
                if (cRule < wRule || wRule < 0) {
                    rule.mark();
                    if (this.isNew(this.listQ, rule)) {
                        this.listQ.add(rule);
                    }
                } else {
                    Structure str = new Structure(i, y, cRule, wRule);
                    this.listA.add(str);
                }
            } else if (wRule > -1) {
                Structure str = new Structure(i, y, cRule, wRule);
                this.listA.add(str);
            }
            ++i;
        }
    }

    private void stage2() {
        int i = 0;
        while (i < this.listA.size()) {
            Structure str = this.listA.get(i);
            int poscRule = str.getIndexCRule();
            int poswRule = str.getIndexWRule();
            RuleCBA wRule = this.rules.get(poswRule);
            if (wRule.isMark()) {
                if (poscRule > -1) {
                    this.rules.get(poscRule).decrementKlassCovered(str.getKlass());
                }
                wRule.incrementKlassCovered(str.getKlass());
            } else {
                int j = 0;
                while (j < this.listU.size()) {
                    RuleCBA rule = this.listU.get(j);
                    if (rule.matching(this.dataset.getInstances().get(str.getdIdInstance()).getItems()) && rule.getKlass() != str.getKlass()) {
                        if (poscRule > -1) {
                            RuleCBA cRule = this.rules.get(poscRule);
                            if (rule.isPrecedence(cRule)) {
                                rule.addReplace(new Replace(poscRule, str.getdIdInstance(), str.getKlass()));
                                rule.incrementKlassCovered(str.getKlass());
                                if (this.isNew(this.listQ, rule)) {
                                    this.listQ.add(rule);
                                }
                            }
                        } else {
                            rule.addReplace(new Replace(poscRule, str.getdIdInstance(), str.getKlass()));
                            rule.incrementKlassCovered(str.getKlass());
                            if (this.isNew(this.listQ, rule)) {
                                this.listQ.add(rule);
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void stage3() {
        this.listC = new ArrayList<SelectedRule>();
        Map<Short, Long> compClassDistr = this.dataset.getMapClassToFrequency();
        long ruleErrors = 0L;
        int[] exampleCovered = new int[this.dataset.getInstances().size()];
        int i = 0;
        while (i < this.dataset.getInstances().size()) {
            exampleCovered[i] = 0;
            ++i;
        }
        Collections.sort(this.listQ);
        i = 0;
        while (i < this.listQ.size()) {
            RuleCBA rule = this.listQ.get(i);
            if (rule.getKlassesCovered(rule.getKlass()) > 0L) {
                int j = 0;
                while (j < rule.getReplaceCount()) {
                    Replace rep = rule.getReplace(j);
                    if (exampleCovered[rep.getdIdInstance()] > 0) {
                        rule.decrementKlassCovered(rep.getKlass());
                    } else if (rep.getIndexCRule() > -1) {
                        this.rules.get(rep.getIndexCRule()).decrementKlassCovered(rep.getKlass());
                    }
                    ++j;
                }
                long errorsOfRule = 0L;
                j = 0;
                while (j < this.dataset.getInstances().size()) {
                    Instance instance;
                    Short[] items;
                    if (exampleCovered[j] < 1 && rule.matching(items = (instance = this.dataset.getInstances().get(j)).getItems())) {
                        exampleCovered[j] = 1;
                        short klass = instance.getKlass();
                        compClassDistr.put(klass, compClassDistr.get(klass) - 1L);
                        if (rule.getKlass() != instance.getKlass().shortValue()) {
                            ++errorsOfRule;
                        }
                    }
                    ++j;
                }
                ruleErrors += errorsOfRule;
                short defaultKlass = this.dataset.getKlassAt(0);
                for (Map.Entry<Short, Long> entry : compClassDistr.entrySet()) {
                    if (compClassDistr.getOrDefault(defaultKlass, 0L) >= entry.getValue()) continue;
                    defaultKlass = entry.getKey();
                }
                Long defaultErrors = 0L;
                for (Map.Entry<Short, Long> entry : compClassDistr.entrySet()) {
                    if (entry.getKey().equals(defaultKlass)) continue;
                    defaultErrors = defaultErrors + entry.getValue();
                }
                Long totalErrors = ruleErrors + defaultErrors;
                this.listC.add(new SelectedRule(rule, defaultKlass, totalErrors));
            }
            ++i;
        }
        if (this.listC.size() > 0) {
            long lowestTotalErrors = this.listC.get(0).getTotalErrors();
            int posLowest = 0;
            i = 1;
            while (i < this.listC.size()) {
                SelectedRule sel = this.listC.get(i);
                if (sel.getTotalErrors() < lowestTotalErrors) {
                    lowestTotalErrors = sel.getTotalErrors();
                    posLowest = i;
                }
                ++i;
            }
            while (this.listC.size() > posLowest + 1) {
                this.listC.remove(posLowest + 1);
            }
        }
    }

    public RuleClassifier getClassifier(String name) {
        RuleClassifier rb = new RuleClassifier(name);
        if (this.listC.size() > 0) {
            SelectedRule sel;
            int i = 0;
            while (i < this.listC.size()) {
                sel = this.listC.get(i);
                rb.add(new RuleCBA(sel.getRule()));
                ++i;
            }
            sel = this.listC.get(this.listC.size() - 1);
            rb.add(new RuleCBA(sel.getDefaultKlass()));
        } else {
            short defaultKlass = this.dataset.getKlassAt(0);
            int i = 0;
            while (i < this.dataset.getClassesCount()) {
                defaultKlass = this.dataset.getKlassAt(0);
                short klass = this.dataset.getKlassAt(i);
                if (this.dataset.getNumberInstancesPerKlass(klass) > this.dataset.getNumberInstancesPerKlass(defaultKlass)) {
                    defaultKlass = klass;
                }
                ++i;
            }
            rb.add(new RuleCBA(defaultKlass));
        }
        return rb;
    }

    private boolean isNew(List<RuleCBA> rb, RuleCBA rule) {
        for (RuleCBA r : rb) {
            if (!rule.equals(r)) continue;
            return false;
        }
        return true;
    }
}

