/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.cmar;

import ca.pfv.spmf.algorithms.classifiers.cmar.CRNode;
import ca.pfv.spmf.algorithms.classifiers.cmar.RuleCMAR;
import ca.pfv.spmf.algorithms.classifiers.data.Dataset;
import ca.pfv.spmf.algorithms.classifiers.data.Instance;
import ca.pfv.spmf.algorithms.classifiers.general.Rule;
import java.util.ArrayList;
import java.util.List;

class CRTree {
    protected static int NUMBER_SINGLETONS;
    private CRNode rootNode = null;
    private int minCover = 4;
    private static final double THRESHOLD_20 = 1.6424;
    private static final double THRESHOLD_CHI_SQUARE = 1.6424;
    public final Dataset dataset;

    CRTree(Dataset dataset, int delta) {
        this.minCover = delta;
        this.dataset = dataset;
    }

    protected void insert(Rule baseRule) {
        RuleCMAR rule = (RuleCMAR)baseRule;
        if (rule.getChiSquare() <= 1.6424) {
            return;
        }
        CRNode newNode = new CRNode(rule);
        if (this.rootNode == null) {
            this.rootNode = newNode;
            return;
        }
        if (this.isMoreGeneralNode(newNode)) {
            return;
        }
        if (newNode.rule.isGreater(this.rootNode.rule)) {
            newNode.next = this.rootNode;
            this.rootNode = newNode;
            return;
        }
        CRNode currentNode = this.rootNode;
        CRNode nextNode = this.rootNode.next;
        while (nextNode != null) {
            if (newNode.rule.isGreater(nextNode.rule)) {
                currentNode.next = newNode;
                newNode.next = nextNode;
                return;
            }
            currentNode = nextNode;
            nextNode = nextNode.next;
        }
        currentNode.next = newNode;
    }

    private boolean isMoreGeneralNode(CRNode ruleNode) {
        CRNode currentNode = this.rootNode;
        while (currentNode != null) {
            if (ruleNode.rule.isMoreGeneral(currentNode.rule) && ruleNode.rule.isGreater(currentNode.rule)) {
                return true;
            }
            currentNode = currentNode.next;
        }
        return false;
    }

    protected void pruneUsingCover() {
        Short[][] datasetArray = new Short[this.dataset.getInstances().size()][];
        List<Instance> instances = this.dataset.getInstances();
        int i = 0;
        while (i < instances.size()) {
            datasetArray[i] = instances.get(i).getItems();
            ++i;
        }
        int[] numberTimesCovered = new int[this.dataset.getInstances().size()];
        CRNode newStart = null;
        CRNode markerRef = null;
        CRNode currentNode = this.rootNode;
        while (currentNode != null) {
            if (this.isEmptyDataSet(datasetArray)) break;
            boolean coveredFlag = false;
            int m = 0;
            while (m < datasetArray.length) {
                if (currentNode.rule.matching(datasetArray[m])) {
                    int n = m;
                    numberTimesCovered[n] = numberTimesCovered[n] + 1;
                    coveredFlag = true;
                }
                ++m;
            }
            if (coveredFlag) {
                if (newStart == null) {
                    newStart = currentNode;
                } else {
                    markerRef.next = currentNode;
                }
                markerRef = currentNode;
                currentNode = currentNode.next;
                markerRef.next = null;
            } else {
                currentNode = currentNode.next;
            }
            int n = 0;
            while (n < numberTimesCovered.length) {
                if (numberTimesCovered[n] > this.minCover) {
                    datasetArray[n] = null;
                }
                ++n;
            }
        }
        this.rootNode = newStart;
    }

    private boolean isEmptyDataSet(Short[][] dataset) {
        Short[][] shortArray = dataset;
        int n = dataset.length;
        int n2 = 0;
        while (n2 < n) {
            Short[] instances = shortArray[n2];
            if (instances != null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public List<Rule> getRules() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        CRNode currentNode = this.rootNode;
        while (currentNode != null) {
            rules.add(currentNode.rule);
            currentNode = currentNode.next;
        }
        return rules;
    }
}

