/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.cmar;

import ca.pfv.spmf.algorithms.classifiers.cmar.FPNode;
import ca.pfv.spmf.algorithms.classifiers.cmar.FPTree;
import ca.pfv.spmf.algorithms.classifiers.cmar.RuleCMAR;
import ca.pfv.spmf.algorithms.classifiers.data.Dataset;
import ca.pfv.spmf.algorithms.classifiers.data.Instance;
import ca.pfv.spmf.algorithms.classifiers.general.Rule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FPGrowthForCMAR {
    protected Dataset dataset;
    private long minSupportRelative;
    protected double minConf;
    final int MAX_SIZE_ANTECEDENT = 2000;
    private FPNode[] fpNodeSingleBuffer = null;
    Map<Short, Long> mapSupport;
    Map<Short, Map<Short, Long>> mapSupportByKlass;
    protected List<Rule> rules;

    public FPGrowthForCMAR(Dataset dataset, double minSup, double minConf) {
        this.minSupportRelative = (long)Math.ceil(minSup * (double)dataset.getInstances().size());
        this.dataset = dataset;
        this.minConf = minConf;
    }

    public List<Rule> run() {
        this.calculateSingletons();
        this.rules = new ArrayList<Rule>();
        FPTree tree = new FPTree();
        for (Instance currentInstance : this.dataset.getInstances()) {
            ArrayList<Short> revisedInstance = new ArrayList<Short>();
            short klass = currentInstance.getKlass();
            int j = 0;
            while (j < this.dataset.getAttributes().size()) {
                Short item = currentInstance.getItems()[j];
                if (this.mapSupport.get(item) >= this.minSupportRelative) {
                    revisedInstance.add(item);
                }
                ++j;
            }
            Collections.sort(revisedInstance, new Comparator<Short>(){

                @Override
                public int compare(Short item1, Short item2) {
                    int compare = FPGrowthForCMAR.this.mapSupport.get(item2).compareTo(FPGrowthForCMAR.this.mapSupport.get(item1));
                    if (compare == 0) {
                        return item1 - item2;
                    }
                    return compare;
                }
            });
            tree.addInstance(revisedInstance, klass);
        }
        tree.createHeaderList(this.mapSupport);
        if (tree.headerList.size() > 0) {
            short[] antecedentBuffer = new short[2000];
            this.fpNodeSingleBuffer = new FPNode[2000];
            this.fpgrowth(tree, antecedentBuffer, 0, this.dataset.getInstances().size(), this.dataset.getMapClassToFrequency(), this.mapSupport, this.mapSupportByKlass);
        }
        return this.rules;
    }

    private void fpgrowth(FPTree tree, short[] prefix, int prefixLength, long prefixSupport, Map<Short, Long> prefixSupportByKlass, Map<Short, Long> mapSupport, Map<Short, Map<Short, Long>> mapSupportByKlass) {
        if (prefixLength == 2000) {
            return;
        }
        boolean singlePath = true;
        int numberSingleItems = 0;
        if (tree.root.childs.size() > 1) {
            singlePath = false;
        } else {
            FPNode currentNode = tree.root.childs.get(0);
            while (true) {
                if (currentNode.childs.size() > 1) {
                    singlePath = false;
                    break;
                }
                this.fpNodeSingleBuffer[numberSingleItems] = currentNode;
                ++numberSingleItems;
                if (currentNode.childs.size() == 0) break;
                currentNode = currentNode.childs.get(0);
            }
        }
        if (singlePath) {
            this.saveAllCombinationsOfPrefixPath(this.fpNodeSingleBuffer, numberSingleItems, prefix, prefixLength);
        } else {
            int i = tree.headerList.size() - 1;
            while (i >= 0) {
                Short item = tree.headerList.get(i);
                Long support = mapSupport.get(item);
                prefix[prefixLength] = item;
                long betaSupport = prefixSupport < support ? prefixSupport : support;
                Map<Short, Long> supportByKlass = mapSupportByKlass.get(item);
                this.generateRules(prefix, prefixLength + 1, betaSupport, supportByKlass);
                if (prefixLength + 1 < 2000) {
                    ArrayList prefixPaths = new ArrayList();
                    FPNode path = tree.mapItemNodes.get(item);
                    HashMap<Short, Long> mapSupportBeta = new HashMap<Short, Long>();
                    HashMap<Short, Map<Short, Long>> mapSupportByKlassBeta = new HashMap<Short, Map<Short, Long>>();
                    while (path != null) {
                        if (path.parent.item != -1) {
                            ArrayList<FPNode> prefixPath = new ArrayList<FPNode>();
                            prefixPath.add(path);
                            long l = path.support;
                            FPNode parent = path.parent;
                            while (parent.item != -1) {
                                prefixPath.add(parent);
                                if (mapSupportBeta.get(parent.item) == null) {
                                    mapSupportBeta.put(parent.item, l);
                                } else {
                                    mapSupportBeta.put(parent.item, (Long)mapSupportBeta.get(parent.item) + l);
                                }
                                if (mapSupportByKlassBeta.get(parent.item) == null) {
                                    mapSupportByKlassBeta.put(parent.item, (HashMap)path.supportByklass.clone());
                                } else {
                                    Map currentByKlass = (Map)mapSupportByKlassBeta.get(parent.item);
                                    for (Map.Entry<Short, Long> entry : path.supportByklass.entrySet()) {
                                        Long count = (Long)currentByKlass.get(entry.getKey());
                                        if (count == null) {
                                            currentByKlass.put(entry.getKey(), entry.getValue());
                                            continue;
                                        }
                                        currentByKlass.put(entry.getKey(), count + entry.getValue());
                                    }
                                }
                                parent = parent.parent;
                            }
                            prefixPaths.add(prefixPath);
                        }
                        path = path.nextNode;
                    }
                    FPTree treeBeta = new FPTree();
                    for (List list : prefixPaths) {
                        treeBeta.addPrefixPath(list, mapSupportBeta, this.minSupportRelative);
                    }
                    if (treeBeta.root.childs.size() > 0) {
                        treeBeta.createHeaderList(mapSupportBeta);
                        this.fpgrowth(treeBeta, prefix, prefixLength + 1, betaSupport, supportByKlass, mapSupportBeta, mapSupportByKlassBeta);
                    }
                }
                --i;
            }
        }
    }

    private void saveAllCombinationsOfPrefixPath(FPNode[] fpNodeTempBuffer, int position, short[] prefix, int prefixLength) {
        long support = 0L;
        HashMap<Short, Long> supportByKlass = null;
        long i = 1L;
        long max = 1 << position;
        while (i < max) {
            block4: {
                int newPrefixLength = prefixLength;
                int j = 0;
                while (j < position) {
                    int isSet = (int)i & 1 << j;
                    if (isSet > 0) {
                        if (newPrefixLength == 2000) break block4;
                        prefix[newPrefixLength++] = fpNodeTempBuffer[j].item;
                        support = fpNodeTempBuffer[j].support;
                        supportByKlass = fpNodeTempBuffer[j].supportByklass;
                    }
                    ++j;
                }
                this.generateRules(prefix, newPrefixLength, support, supportByKlass);
            }
            ++i;
        }
    }

    private void calculateSingletons() {
        this.mapSupport = new HashMap<Short, Long>();
        this.mapSupportByKlass = new HashMap<Short, Map<Short, Long>>();
        List<Instance> instances = this.dataset.getInstances();
        for (Instance instance : instances) {
            Short klass = instance.getKlass();
            int j = 0;
            while (j < this.dataset.getAttributes().size()) {
                Short item = instance.getItems()[j];
                Long count = this.mapSupport.getOrDefault(item, 0L);
                count = count + 1L;
                this.mapSupport.put(item, count);
                Map<Short, Long> byKlass = this.mapSupportByKlass.get(item);
                if (byKlass == null) {
                    this.mapSupportByKlass.put(item, new HashMap());
                    this.mapSupportByKlass.get(item).put(klass, 1L);
                } else {
                    Long counter = byKlass.getOrDefault(klass, 0L);
                    byKlass.put(klass, counter + 1L);
                }
                ++j;
            }
        }
    }

    protected void generateRules(short[] antecedent, int antecedentLength, long support, Map<Short, Long> counterByKlass) {
        short[] itemsetOutputBuffer = new short[antecedentLength];
        System.arraycopy(antecedent, 0, itemsetOutputBuffer, 0, antecedentLength);
        Arrays.sort(itemsetOutputBuffer, 0, antecedentLength);
        for (Map.Entry<Short, Long> entry : counterByKlass.entrySet()) {
            RuleCMAR rule = new RuleCMAR(itemsetOutputBuffer, (short)entry.getKey());
            rule.setSupportAntecedent(support);
            rule.setSupportRule(entry.getValue());
            rule.setSupportKlass(this.dataset.getMapClassToFrequency().get(rule.getKlass()));
            if (rule.getSupportRule() < this.minSupportRelative || !(rule.getConfidence() >= this.minConf)) continue;
            this.rules.add(rule);
        }
    }
}

