/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.decisiontree.id3;

import ca.pfv.spmf.algorithms.classifiers.data.Attribute;
import ca.pfv.spmf.algorithms.classifiers.data.Instance;
import ca.pfv.spmf.algorithms.classifiers.decisiontree.id3.ClassNode;
import ca.pfv.spmf.algorithms.classifiers.decisiontree.id3.DecisionNode;
import ca.pfv.spmf.algorithms.classifiers.decisiontree.id3.Node;
import ca.pfv.spmf.algorithms.classifiers.general.Classifier;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class DecisionTree
implements Serializable {
    private static final long serialVersionUID = -8418751744654245253L;
    Node root = null;
    private Map<Short, String> mapItemToString;
    private List<Attribute> attributeList;

    public DecisionTree(Map<Short, String> mapItemToString, List<Attribute> attributeList) {
        this.mapItemToString = mapItemToString;
        this.attributeList = attributeList;
    }

    public void print() {
        System.out.println("DECISION TREE");
        String indent = " ";
        this.print(this.root, indent, null);
    }

    private void print(Node nodeToPrint, String indent, Short value) {
        if (value == null) {
            System.out.println(String.valueOf(indent) + "Root");
        }
        String newIndent = String.valueOf(indent) + "  ";
        if (nodeToPrint instanceof ClassNode) {
            ClassNode node = (ClassNode)nodeToPrint;
            String name = this.mapItemToString.get(node.className);
            System.out.println(String.valueOf(newIndent) + "  =" + name);
        } else {
            DecisionNode node = (DecisionNode)nodeToPrint;
            String nameOfClass = this.attributeList.get(node.attribute).getName();
            System.out.println(String.valueOf(newIndent) + nameOfClass + "->");
            newIndent = String.valueOf(newIndent) + "  ";
            int i = 0;
            while (i < node.nodes.length) {
                this.mapItemToString.get(node.attributeValues[i]);
                this.print(node.nodes[i], newIndent, node.attributeValues[i]);
                ++i;
            }
        }
    }

    public Short predictTargetAttributeValue(Instance instance) {
        return this.predict(this.root, instance);
    }

    private Short predict(Node currentNode, Instance instance) {
        if (currentNode instanceof ClassNode) {
            ClassNode node = (ClassNode)currentNode;
            return node.className;
        }
        DecisionNode node = (DecisionNode)currentNode;
        Short value = instance.getItems()[node.attribute];
        int i = 0;
        while (i < node.attributeValues.length) {
            if (node.attributeValues[i].equals(value)) {
                return this.predict(node.nodes[i], instance);
            }
            ++i;
        }
        return Classifier.NOPREDICTION;
    }
}

