/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.general;

import ca.pfv.spmf.algorithms.classifiers.data.Dataset;
import ca.pfv.spmf.algorithms.classifiers.general.Classifier;
import ca.pfv.spmf.algorithms.classifiers.general.RuleClassifier;
import ca.pfv.spmf.tools.MemoryLogger;

public abstract class ClassificationAlgorithm {
    private long trainingTime;
    private double trainingMaxMemory;
    private Classifier classifier;

    public Classifier trainAndCalculateStats(Dataset training) throws Exception {
        MemoryLogger.getInstance().reset();
        this.trainingTime = System.currentTimeMillis();
        this.classifier = this.train(training);
        MemoryLogger.getInstance().checkMemory();
        this.trainingTime = System.currentTimeMillis() - this.trainingTime;
        this.trainingMaxMemory = MemoryLogger.getInstance().getMaxMemory();
        return this.classifier;
    }

    protected abstract Classifier train(Dataset var1);

    public long getTrainingTime() {
        return this.trainingTime;
    }

    public double getTrainingMaxMemory() {
        return this.trainingMaxMemory;
    }

    public abstract String getName();

    public void printStats() {
        System.out.println("============= " + this.getName() + "- STATS =============");
        System.out.println("Training time (ms):" + this.trainingTime);
        System.out.println("Max Memory (mb):" + this.trainingMaxMemory);
        if (this.classifier instanceof RuleClassifier) {
            RuleClassifier ruleClassifier = (RuleClassifier)this.classifier;
            System.out.println("Rule count: " + ruleClassifier.getNumberRules());
            System.out.println("Average attribute count per rule: " + ruleClassifier.getAverageNumberAttributes());
        }
        System.out.println("===================================================");
    }
}

