/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.general;

import ca.pfv.spmf.algorithms.classifiers.data.Dataset;
import ca.pfv.spmf.algorithms.classifiers.data.Instance;
import ca.pfv.spmf.algorithms.classifiers.data.VirtualDataset;
import ca.pfv.spmf.algorithms.classifiers.general.ClassificationAlgorithm;
import ca.pfv.spmf.algorithms.classifiers.general.Classifier;
import ca.pfv.spmf.algorithms.classifiers.general.ConfusionMatrix;
import ca.pfv.spmf.algorithms.classifiers.general.OverallResults;
import ca.pfv.spmf.algorithms.classifiers.general.RuleClassifier;
import ca.pfv.spmf.tools.MemoryLogger;
import java.util.ArrayList;
import java.util.List;

public class Evaluator {
    private boolean DEBUGMODE = false;

    private void runOnInstancesAnUpdateResults(Dataset dataset, Classifier classifier, ClassificationResults results) {
        MemoryLogger.getInstance().reset();
        long thisRuntime = System.currentTimeMillis();
        for (Instance instance : dataset.getInstances()) {
            short predictedKlassIndex = classifier.predict(instance);
            short realKlassIndex = instance.getKlass();
            results.predictedClasses.add(predictedKlassIndex);
            results.matrix.add(realKlassIndex, predictedKlassIndex);
        }
        results.runtime += System.currentTimeMillis() - thisRuntime;
        MemoryLogger.getInstance().checkMemory();
        results.memory = results.memory + MemoryLogger.getInstance().getMaxMemory();
    }

    public OverallResults trainAndRunClassifiersHoldout(ClassificationAlgorithm[] algorithms, Dataset dataset, double percentage) throws Exception {
        ArrayList<String> names = new ArrayList<String>();
        ClassificationAlgorithm[] classificationAlgorithmArray = algorithms;
        int n = algorithms.length;
        int n2 = 0;
        while (n2 < n) {
            ClassificationAlgorithm algorithm = classificationAlgorithmArray[n2];
            names.add(algorithm.getName());
            ++n2;
        }
        OverallResults allResults = new OverallResults(names);
        if (percentage <= 0.0 || percentage >= 1.0) {
            throw new RuntimeException("Sampling percentage must be in the range [0,1]");
        }
        Dataset[] datasets = VirtualDataset.splitDatasetForHoldout(dataset, percentage);
        Dataset training = datasets[0];
        Dataset testing = datasets[1];
        if (this.DEBUGMODE) {
            System.out.println("===== HOLDOUT SAMPLING =====");
            System.out.println("Holdout sampling with percentage = " + percentage);
            System.out.println("  - Original dataset: " + dataset.getInstances().size() + " records.");
            System.out.println("  - Training part: " + training.getInstances().size() + " records.");
            System.out.println("  - Testing part: " + testing.getInstances().size() + " records.");
            System.out.println("===== RUNNING =====");
        }
        ClassificationAlgorithm[] classificationAlgorithmArray2 = algorithms;
        int n3 = algorithms.length;
        int n4 = 0;
        while (n4 < n3) {
            ClassificationAlgorithm algorithm = classificationAlgorithmArray2[n4];
            if (this.DEBUGMODE) {
                System.out.println("Running algorithm ... " + algorithm.getName());
            }
            Classifier classifier = algorithm.trainAndCalculateStats(training);
            TrainingResults trainResults = new TrainingResults();
            trainResults.memory = trainResults.memory + algorithm.getTrainingMaxMemory();
            trainResults.runtime += algorithm.getTrainingTime();
            if (classifier instanceof RuleClassifier) {
                trainResults.avgRuleCount += (double)((RuleClassifier)classifier).getNumberRules();
            }
            ClassificationResults resultsOnTraining = new ClassificationResults();
            this.runOnInstancesAnUpdateResults(training, classifier, resultsOnTraining);
            ClassificationResults resultsOnTesting = new ClassificationResults();
            this.runOnInstancesAnUpdateResults(testing, classifier, resultsOnTesting);
            allResults.addResults(resultsOnTraining, resultsOnTesting, trainResults);
            ++n4;
        }
        return allResults;
    }

    public OverallResults trainAndRunClassifiersKFold(ClassificationAlgorithm[] algorithms, Dataset dataset, int k) throws Exception {
        ArrayList<String> names = new ArrayList<String>();
        ClassificationAlgorithm[] classificationAlgorithmArray = algorithms;
        int n = algorithms.length;
        int n2 = 0;
        while (n2 < n) {
            ClassificationAlgorithm algorithm = classificationAlgorithmArray[n2];
            names.add(algorithm.getName());
            ++n2;
        }
        OverallResults allResults = new OverallResults(names);
        if (k < 2) {
            throw new RuntimeException("k needs to be 2 or more");
        }
        double relativeRatio = 1.0 / (double)k;
        int absoluteRatio = (int)Math.ceil((double)dataset.getInstances().size() * relativeRatio);
        int i = 0;
        while (i < k) {
            int posStart = i * absoluteRatio;
            int posEnd = posStart + absoluteRatio;
            if (i == k - 1) {
                posEnd = dataset.getInstances().size();
            }
            Dataset[] datasets = VirtualDataset.splitDatasetForKFold(dataset, posStart, posEnd);
            Dataset training = datasets[0];
            Dataset testing = datasets[1];
            if (this.DEBUGMODE) {
                System.out.println("===== KFOLD " + i + " =====");
                System.out.println(" k = " + k);
                System.out.println("  - Original dataset: " + dataset.getInstances().size() + " records.");
                System.out.println("  - Training part: " + training.getInstances().size() + " records.");
                System.out.println("  - Testing part: " + testing.getInstances().size() + " records.");
                System.out.println("===== RUNNING =====");
            }
            ClassificationAlgorithm[] classificationAlgorithmArray2 = algorithms;
            int n3 = algorithms.length;
            int n4 = 0;
            while (n4 < n3) {
                ClassificationAlgorithm algorithm = classificationAlgorithmArray2[n4];
                if (this.DEBUGMODE) {
                    System.out.println("Running algorithm ... " + algorithm.getName());
                }
                Classifier classifier = algorithm.trainAndCalculateStats(testing);
                TrainingResults trainResults = new TrainingResults();
                trainResults.memory = trainResults.memory + algorithm.getTrainingMaxMemory();
                trainResults.runtime += algorithm.getTrainingTime();
                if (classifier instanceof RuleClassifier) {
                    trainResults.avgRuleCount += (double)((RuleClassifier)classifier).getNumberRules() / (double)k;
                }
                ClassificationResults resultsOnTraining = new ClassificationResults();
                this.runOnInstancesAnUpdateResults(training, classifier, resultsOnTraining);
                ClassificationResults resultsOnTesting = new ClassificationResults();
                this.runOnInstancesAnUpdateResults(testing, classifier, resultsOnTesting);
                allResults.addResults(resultsOnTraining, resultsOnTesting, trainResults);
                ++n4;
            }
            ++i;
        }
        return allResults;
    }

    class ClassificationResults {
        ConfusionMatrix matrix = new ConfusionMatrix();
        List<Short> predictedClasses = new ArrayList<Short>();
        long runtime = 0L;
        Double memory = 0.0;

        ClassificationResults() {
        }
    }

    class TrainingResults {
        long runtime = 0L;
        Double memory = 0.0;
        double avgRuleCount = 0.0;

        TrainingResults() {
        }
    }
}

