/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.general;

import ca.pfv.spmf.algorithms.classifiers.data.Dataset;
import ca.pfv.spmf.algorithms.classifiers.data.Instance;
import ca.pfv.spmf.algorithms.classifiers.general.Classifier;
import ca.pfv.spmf.algorithms.classifiers.general.ConfusionMatrix;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class ExperimentForClassifier {
    private ConfusionMatrix matrix;
    List<Short> predictedClassesID;
    long runtimeClassification;
    double memoryUsage;

    public void runExperiment(Classifier classifier, Dataset dataset) {
        MemoryLogger.getInstance().reset();
        this.runtimeClassification = System.currentTimeMillis();
        this.predictedClassesID = new ArrayList<Short>();
        this.matrix = new ConfusionMatrix();
        int i = 0;
        while (i < dataset.getInstances().size()) {
            Instance instance = dataset.getInstances().get(i);
            short predictedKlassIndex = classifier.predict(instance);
            short realKlassIndex = instance.getKlass();
            this.predictedClassesID.add(predictedKlassIndex);
            this.matrix.add(realKlassIndex, predictedKlassIndex);
            ++i;
        }
        this.runtimeClassification = System.currentTimeMillis() - this.runtimeClassification;
        MemoryLogger.getInstance().checkMemory();
        this.memoryUsage = MemoryLogger.getInstance().getMaxMemory();
    }

    public void saveMetricsResultsToFile(String metricsReportPath) {
        try {
            PrintWriter metricsWriter = new PrintWriter(metricsReportPath, "UTF-8");
            metricsWriter.write(this.metricsToString());
            metricsWriter.close();
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void savePredictedClassesToFileAsString(Dataset dataset, String predictedClassReportPath) {
        try {
            PrintWriter predictedClassWriter = new PrintWriter(predictedClassReportPath, "UTF-8");
            predictedClassWriter.println("realKlass, predictedKlass");
            int i = 0;
            while (i < dataset.getInstances().size()) {
                short predictedKlassIndex = this.predictedClassesID.get(i);
                short realKlassIndex = dataset.getInstances().get(i).getKlass();
                String realKlass = dataset.getStringCorrespondingToItem(realKlassIndex);
                String predictedKlass = dataset.getStringCorrespondingToItem(predictedKlassIndex);
                predictedClassWriter.println(String.valueOf(realKlass) + "," + predictedKlass);
                ++i;
            }
            predictedClassWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printStats() {
        System.out.println(this.metricsToString());
    }

    private String metricsToString() {
        StringBuilder builder = new StringBuilder();
        builder.append("#ACCURACY: " + this.matrix.getAccuracy());
        builder.append(System.lineSeparator());
        builder.append("#RECALL: " + this.matrix.getAverageRecall());
        builder.append(System.lineSeparator());
        builder.append("#PRECISION: " + this.matrix.getAveragePrecision());
        builder.append(System.lineSeparator());
        builder.append("#KAPPA: " + this.matrix.getKappa());
        builder.append(System.lineSeparator());
        builder.append("#F-MEASURE-MICRO: " + this.matrix.getMicroFMeasure());
        builder.append(System.lineSeparator());
        builder.append("#F-MEASURE-MACRO: " + this.matrix.getMacroFMeasure());
        builder.append(System.lineSeparator());
        builder.append("#NOPREDICTION-PERCENTAGE: " + this.matrix.getNopredictions());
        builder.append(System.lineSeparator());
        builder.append("#CLASSIFICATION-TIME-ms: " + this.runtimeClassification);
        builder.append(System.lineSeparator());
        builder.append("#MEMORY-mb: " + this.memoryUsage);
        return builder.toString();
    }
}

