/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.general;

import ca.pfv.spmf.algorithms.ArraysAlgos;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class Rule
implements Serializable {
    private static final long serialVersionUID = -1232107487609781014L;
    protected List<Short> antecedent;
    protected short klass;
    protected long supportAntecedent;
    protected long supportKlass;
    protected long supportRule;

    public Rule() {
        this.antecedent = new ArrayList<Short>();
        this.supportRule = 0L;
        this.supportAntecedent = 0L;
        this.supportKlass = 0L;
    }

    public Rule(Rule rule) {
        this.klass = rule.klass;
        this.add(rule.antecedent);
        this.supportAntecedent = rule.supportAntecedent;
        this.supportKlass = rule.supportKlass;
        this.supportRule = rule.supportRule;
    }

    public Rule(short klass) {
        this();
        this.klass = klass;
    }

    public Rule(short[] antecedent, short klass) {
        this(klass);
        this.add(antecedent);
    }

    public Rule(Short[] antecedent, short klass) {
        this(klass);
        this.add(antecedent);
    }

    public List<Short> getAntecedent() {
        return this.antecedent;
    }

    public boolean isANegativeRule() {
        return false;
    }

    public boolean isIthAntecedentItemNegative(int i) {
        return false;
    }

    public List<Short> isItemOfAntecedentNegative() {
        return this.antecedent;
    }

    public double getConfidence() {
        double confidence = (double)this.supportRule / (double)this.supportAntecedent;
        return (double)this.supportAntecedent > 0.0 ? confidence : 0.0;
    }

    public long getSupportRule() {
        return this.supportRule;
    }

    public long getSupportKlass() {
        return this.supportKlass;
    }

    public boolean matching(Short[] instance) {
        if (this.antecedent.isEmpty()) {
            return true;
        }
        if (instance == null) {
            return true;
        }
        return ArraysAlgos.isSubsetOf(this.antecedent, instance);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        Rule rule = (Rule)other;
        if (this.klass != rule.getKlass()) {
            return false;
        }
        if (this.antecedent.size() != rule.getAntecedent().size()) {
            return false;
        }
        int i = 0;
        while (i < this.antecedent.size()) {
            if (this.antecedent.get(i) != rule.antecedent.get(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void add(Short[] itemset2) {
        int i = 0;
        while (i < itemset2.length) {
            this.antecedent.add(itemset2[i]);
            ++i;
        }
    }

    public void add(List<Short> itemset2) {
        this.antecedent.addAll(itemset2);
    }

    public void add(short[] itemset2) {
        int i = 0;
        while (i < itemset2.length) {
            this.antecedent.add(itemset2[i]);
            ++i;
        }
    }

    public void add(short item) {
        this.antecedent.add(item);
    }

    public short get(int index) {
        return this.antecedent.get(index);
    }

    public int size() {
        return this.antecedent.size();
    }

    public short getKlass() {
        return this.klass;
    }

    public long getSupportAntecedent() {
        return this.supportAntecedent;
    }

    public void incrementSupportAntecedent() {
        ++this.supportAntecedent;
    }

    public void incrementSupportRule() {
        ++this.supportRule;
    }

    public void setKlass(short klass) {
        this.klass = klass;
    }

    public int hashCode() {
        ArrayList<Short> total = new ArrayList<Short>(this.antecedent);
        total.add(this.klass);
        return total.hashCode();
    }

    public void setSupportAntecedent(long supportAntecedent) {
        this.supportAntecedent = supportAntecedent;
    }

    public void setSupportRule(long supportRule) {
        this.supportRule = supportRule;
    }

    public void setSupportKlass(long supportKlass) {
        this.supportKlass = supportKlass;
    }

    protected static double errors(double N, double e) {
        double CF = 0.25;
        double[] VAL = new double[]{0.0, 1.0E-9, 1.0E-8, 1.0E-7, 1.0E-6, 1.0E-5, 5.0E-5, 1.0E-4, 5.0E-4, 0.001, 0.005, 0.01, 0.05, 0.1, 0.2, 0.4, 1.0};
        double[] DEV = new double[]{100.0, 6.0, 5.61, 5.2, 4.75, 4.26, 3.89, 3.72, 3.29, 3.09, 2.58, 2.33, 1.65, 1.28, 0.84, 0.25, 0.0};
        int i = 0;
        while (CF > VAL[i]) {
            ++i;
        }
        double coeff = DEV[i - 1] + (DEV[i] - DEV[i - 1]) * (CF - VAL[i - 1]) / (VAL[i] - VAL[i - 1]);
        coeff *= coeff;
        if (e == 0.0) {
            return N * (1.0 - Math.exp(Math.log(CF) / N));
        }
        if (e < 0.9999) {
            double Val0 = N * (1.0 - Math.exp(Math.log(CF) / N));
            return Val0 + e * (Rule.errors(N, 1.0) - Val0);
        }
        if (e + 0.5 >= N) {
            return 0.67 * (N - e);
        }
        double Pr = (e + 0.5 + coeff / 2.0 + Math.sqrt(coeff * ((e + 0.5) * (1.0 - (e + 0.5) / N) + coeff / 4.0))) / (N + coeff);
        return N * Pr - e;
    }

    public boolean isCombinable(Rule other) {
        short itemj;
        if (this.getKlass() != other.getKlass()) {
            return false;
        }
        if (this.size() != other.size()) {
            return false;
        }
        int i = 0;
        while (i < this.size() - 1) {
            if (this.get(i) != other.get(i)) {
                return false;
            }
            ++i;
        }
        short itemi = this.get(this.size() - 1);
        return itemi < (itemj = other.get(other.size() - 1));
    }

    public String toString() {
        return String.valueOf(this.antecedent.toString()) + " -> " + this.getKlass() + this.getMeasuresToString();
    }

    public abstract String getMeasuresToString();
}

