/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.general;

import ca.pfv.spmf.algorithms.classifiers.data.Attribute;
import ca.pfv.spmf.algorithms.classifiers.data.Dataset;
import ca.pfv.spmf.algorithms.classifiers.data.Instance;
import ca.pfv.spmf.algorithms.classifiers.data.StringDataset;
import ca.pfv.spmf.algorithms.classifiers.general.Classifier;
import ca.pfv.spmf.algorithms.classifiers.general.Rule;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class RuleClassifier
extends Classifier
implements Serializable {
    private static final long serialVersionUID = -3339753093228301309L;
    protected List<Rule> rules = new ArrayList<Rule>();
    protected String name;

    public RuleClassifier(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void add(Rule rule) {
        this.rules.add(rule);
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    @Override
    public short predict(Instance rawExample) {
        Short[] example = rawExample.getItems();
        for (Rule rule : this.rules) {
            if (!rule.matching(example)) continue;
            return rule.getKlass();
        }
        return NOPREDICTION;
    }

    public int getNumberRules() {
        return this.rules.size();
    }

    public double getAverageNumberAttributes() {
        double avg = 0.0;
        for (Rule rule : this.rules) {
            avg += (double)rule.getAntecedent().size();
        }
        return avg / (double)this.getNumberRules();
    }

    public void writeRulesToFileSPMFFormatAsNumbers(String outputPath) {
        try {
            PrintWriter writer = new PrintWriter(outputPath, "UTF-8");
            for (Rule rule : this.rules) {
                int antecedentSize = rule.getAntecedent().size();
                StringBuilder buffer = new StringBuilder();
                int j = 0;
                while (j < antecedentSize) {
                    buffer.append(rule.getAntecedent().get(j));
                    if (rule.isIthAntecedentItemNegative(j)) {
                        buffer.append('-');
                    }
                    if (j != antecedentSize - 1) {
                        buffer.append(" ");
                    }
                    ++j;
                }
                if (antecedentSize == 0) {
                    buffer.append("DEFAULT");
                }
                buffer.append(" ==> ");
                buffer.append(rule.getKlass());
                if (antecedentSize != 0) {
                    buffer.append(rule.getMeasuresToString());
                }
                writer.println(buffer.toString());
            }
            writer.close();
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void writeRulesToFileSPMFFormatAsStrings(String outputPath, StringDataset dataset) {
        try {
            PrintWriter writer = new PrintWriter(outputPath, "UTF-8");
            for (Rule rule : this.rules) {
                int antecedentSize = rule.getAntecedent().size();
                StringBuilder buffer = new StringBuilder();
                int j = 0;
                while (j < antecedentSize) {
                    String item = dataset.getStringCorrespondingToItem(rule.getAntecedent().get(j));
                    if (rule.isIthAntecedentItemNegative(j)) {
                        buffer.append('-');
                    }
                    buffer.append(item);
                    if (j != antecedentSize - 1) {
                        buffer.append(" ");
                    }
                    ++j;
                }
                if (antecedentSize == 0) {
                    buffer.append("DEFAULT");
                }
                buffer.append(" ==> ");
                buffer.append(dataset.getStringCorrespondingToItem(rule.getKlass()));
                if (antecedentSize != 0) {
                    buffer.append(rule.getMeasuresToString());
                }
                writer.println(buffer.toString());
            }
            writer.close();
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void writeWithSringNames(Dataset training, String outputPath) {
        try {
            PrintWriter writer = new PrintWriter(outputPath, "UTF-8");
            for (Rule rule : this.rules) {
                CharSequence[] antecedent = new String[rule.getAntecedent().size()];
                int j = 0;
                while (j < antecedent.length) {
                    Short item = rule.getAntecedent().get(j);
                    Attribute attr = training.getAttributeOfItem(item);
                    antecedent[j] = String.valueOf(attr.getName()) + "=" + training.getStringCorrespondingToItem(item);
                    ++j;
                }
                String klass = training.getStringCorrespondingToItem(rule.getKlass());
                writer.println(String.valueOf(String.join((CharSequence)" ", antecedent)) + " => " + klass);
            }
            writer.close();
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }
}

