/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.l3;

import ca.pfv.spmf.algorithms.classifiers.data.Dataset;
import ca.pfv.spmf.algorithms.classifiers.data.Instance;
import ca.pfv.spmf.algorithms.classifiers.general.Rule;
import ca.pfv.spmf.algorithms.classifiers.general.RuleClassifier;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ClassifierL3
extends RuleClassifier {
    private static final long serialVersionUID = 4178759210062021733L;

    public ClassifierL3(Dataset training, List<Rule> rules) {
        super("L3");
        ArrayList<Rule> lI = new ArrayList<Rule>();
        ArrayList<Rule> lII = new ArrayList<Rule>();
        ArrayList<Rule> sortedRules = new ArrayList<Rule>(rules);
        Collections.sort(sortedRules, new Comparator<Rule>(){

            @Override
            public int compare(Rule arg0, Rule arg1) {
                if (Double.compare(arg0.getConfidence(), arg1.getConfidence()) != 0) {
                    return -Double.compare(arg0.getConfidence(), arg1.getConfidence());
                }
                if (Double.compare(arg0.getSupportRule(), arg1.getSupportRule()) != 0) {
                    return -Double.compare(arg0.getSupportRule(), arg1.getSupportRule());
                }
                if (Integer.compare(arg0.size(), arg1.size()) != 0) {
                    return -Integer.compare(arg0.size(), arg1.size());
                }
                int i = 0;
                while (i < arg0.size()) {
                    short y;
                    short x = arg0.getAntecedent().get(i);
                    if (Integer.compare(x, y = arg1.getAntecedent().get(i).shortValue()) != 0) {
                        return Integer.compare(x, y);
                    }
                    ++i;
                }
                return Integer.compare(arg0.getKlass(), arg1.getKlass());
            }
        });
        BitSet instanceCovered = new BitSet(training.getInstances().size());
        for (Rule rule : sortedRules) {
            int correctly = 0;
            int incorrectly = 0;
            int i = 0;
            while (i < training.getInstances().size()) {
                Instance instance = training.getInstances().get(i);
                Short[] items = instance.getItems();
                if (!instanceCovered.get(i) && rule.matching(items)) {
                    if (rule.getKlass() == instance.getKlass().shortValue()) {
                        ++correctly;
                        instanceCovered.set(i);
                    } else {
                        ++incorrectly;
                    }
                }
                ++i;
            }
            if (correctly > 0) {
                lI.add(rule);
                continue;
            }
            if (correctly != 0 || incorrectly != 0) continue;
            lII.add(rule);
        }
        this.rules = lI;
        this.rules.addAll(lII);
    }

    @Override
    public short predict(Instance instance) {
        for (Rule rule : this.rules) {
            if (!rule.matching(instance.getItems())) continue;
            return rule.getKlass();
        }
        return NOPREDICTION;
    }
}

