/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.classifiers.mac;

import ca.pfv.spmf.algorithms.ArraysAlgos;
import ca.pfv.spmf.algorithms.classifiers.data.Dataset;
import ca.pfv.spmf.algorithms.classifiers.data.Instance;
import ca.pfv.spmf.algorithms.classifiers.general.RuleClassifier;
import ca.pfv.spmf.algorithms.classifiers.mac.RuleMAC;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClassifierMAC
extends RuleClassifier {
    private static final long serialVersionUID = 5516816919309986278L;

    public ClassifierMAC(Dataset dataset, List<RuleMAC> listRules) {
        super("MAC");
        Object instance;
        int i;
        Collections.sort(listRules, new Comparator<RuleMAC>(){

            @Override
            public int compare(RuleMAC arg0, RuleMAC arg1) {
                if (Double.compare(arg0.getConfidence(), arg1.getConfidence()) != 0) {
                    return -Double.compare(arg0.getConfidence(), arg1.getConfidence());
                }
                if (Double.compare(arg0.getSupportRule(), arg1.getSupportRule()) != 0) {
                    return -Double.compare(arg0.getSupportRule(), arg1.getSupportRule());
                }
                return -Integer.compare(arg0.size(), arg1.size());
            }
        });
        BitSet coveredX = new BitSet(dataset.getInstances().size());
        List<Instance> instances = dataset.getInstances();
        for (RuleMAC rule : listRules) {
            i = 0;
            while (i < instances.size()) {
                instance = instances.get(i).getItems();
                if (!coveredX.get(i) && ArraysAlgos.isSubsetOf(rule.getAntecedent(), (Short[])instance)) {
                    coveredX.set(i);
                    if (!this.rules.contains(rule)) {
                        this.rules.add(rule);
                    }
                }
                ++i;
            }
        }
        Boolean allAreCovered = !coveredX.isEmpty();
        HashMap<Short, Long> classesCounter = new HashMap<Short, Long>();
        if (allAreCovered.booleanValue()) {
            int k = 0;
            while (k < this.rules.size()) {
                RuleMAC rule = (RuleMAC)this.rules.get(k);
                Long counter = classesCounter.getOrDefault(rule.getKlass(), 0L);
                classesCounter.put(rule.getKlass(), counter + 1L);
                ++k;
            }
        } else {
            i = 0;
            while (i < instances.size()) {
                if (!coveredX.get(i)) {
                    instance = instances.get(i);
                    short klass = ((Instance)instance).getKlass();
                    Long counter = classesCounter.getOrDefault(klass, 0L);
                    classesCounter.put(klass, counter + 1L);
                }
                ++i;
            }
        }
        Short defaultKlass = null;
        Long counter = null;
        for (Map.Entry entry : classesCounter.entrySet()) {
            if (defaultKlass != null && counter >= (Long)entry.getValue()) continue;
            counter = (Long)entry.getValue();
            defaultKlass = (Short)entry.getKey();
        }
        RuleMAC defaultRule = new RuleMAC(defaultKlass);
        this.add(defaultRule);
    }

    @Override
    public short predict(Instance instance) {
        Short[] instanceItems = instance.getItems();
        HashMap<Short, Long> matchPerKlass = new HashMap<Short, Long>();
        short defaultKlass = -1;
        int i = 0;
        while (i < this.rules.size()) {
            RuleMAC rule = (RuleMAC)this.rules.get(i);
            if (rule.getAntecedent().isEmpty()) {
                defaultKlass = rule.getKlass();
            } else if (ArraysAlgos.isSubsetOf(rule.getAntecedent(), instanceItems)) {
                Long counter = matchPerKlass.getOrDefault(rule.getKlass(), 0L);
                matchPerKlass.put(rule.getKlass(), counter + 1L);
            }
            ++i;
        }
        if (matchPerKlass.isEmpty()) {
            return defaultKlass;
        }
        Map.Entry max = Collections.max(matchPerKlass.entrySet(), (entry1, entry2) -> ((Long)entry1.getValue()).compareTo((Long)entry2.getValue()));
        return (Short)max.getKey();
    }
}

